/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelbuilding.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelbuilding.model.Message;
import com.amazonaws.services.lexmodelbuilding.model.transform.PromptMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Prompt
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Message> messages;
    private Integer maxAttempts;
    private String responseCard;

    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(Collection<Message> messages) {
        if (messages == null) {
            this.messages = null;
            return;
        }
        this.messages = new ArrayList<Message>(messages);
    }

    public Prompt withMessages(Message ... messages) {
        if (this.messages == null) {
            this.setMessages(new ArrayList<Message>(messages.length));
        }
        for (Message ele : messages) {
            this.messages.add(ele);
        }
        return this;
    }

    public Prompt withMessages(Collection<Message> messages) {
        this.setMessages(messages);
        return this;
    }

    public void setMaxAttempts(Integer maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public Integer getMaxAttempts() {
        return this.maxAttempts;
    }

    public Prompt withMaxAttempts(Integer maxAttempts) {
        this.setMaxAttempts(maxAttempts);
        return this;
    }

    public void setResponseCard(String responseCard) {
        this.responseCard = responseCard;
    }

    public String getResponseCard() {
        return this.responseCard;
    }

    public Prompt withResponseCard(String responseCard) {
        this.setResponseCard(responseCard);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMessages() != null) {
            sb.append("Messages: ").append(this.getMessages()).append(",");
        }
        if (this.getMaxAttempts() != null) {
            sb.append("MaxAttempts: ").append(this.getMaxAttempts()).append(",");
        }
        if (this.getResponseCard() != null) {
            sb.append("ResponseCard: ").append(this.getResponseCard());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Prompt)) {
            return false;
        }
        Prompt other = (Prompt)obj;
        if (other.getMessages() == null ^ this.getMessages() == null) {
            return false;
        }
        if (other.getMessages() != null && !other.getMessages().equals(this.getMessages())) {
            return false;
        }
        if (other.getMaxAttempts() == null ^ this.getMaxAttempts() == null) {
            return false;
        }
        if (other.getMaxAttempts() != null && !other.getMaxAttempts().equals(this.getMaxAttempts())) {
            return false;
        }
        if (other.getResponseCard() == null ^ this.getResponseCard() == null) {
            return false;
        }
        return other.getResponseCard() == null || other.getResponseCard().equals(this.getResponseCard());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMessages() == null ? 0 : this.getMessages().hashCode());
        hashCode = 31 * hashCode + (this.getMaxAttempts() == null ? 0 : this.getMaxAttempts().hashCode());
        hashCode = 31 * hashCode + (this.getResponseCard() == null ? 0 : this.getResponseCard().hashCode());
        return hashCode;
    }

    public Prompt clone() {
        try {
            return (Prompt)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PromptMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

