/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.services.elasticache.model.ReshardingStatus;
import com.amazonaws.services.elasticache.model.transform.SlotMigrationStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ReshardingStatusStaxUnmarshaller
implements Unmarshaller<ReshardingStatus, StaxUnmarshallerContext> {
    private static ReshardingStatusStaxUnmarshaller instance;

    @Override
    public ReshardingStatus unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReshardingStatus reshardingStatus = new ReshardingStatus();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return reshardingStatus;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("SlotMigration", targetDepth)) continue;
                reshardingStatus.setSlotMigration(SlotMigrationStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return reshardingStatus;
    }

    public static ReshardingStatusStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ReshardingStatusStaxUnmarshaller();
        }
        return instance;
    }
}

