/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworkscm;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.opsworkscm.AWSOpsWorksCM;
import com.amazonaws.services.opsworkscm.AWSOpsWorksCMClientBuilder;
import com.amazonaws.services.opsworkscm.model.AWSOpsWorksCMException;
import com.amazonaws.services.opsworkscm.model.AssociateNodeRequest;
import com.amazonaws.services.opsworkscm.model.AssociateNodeResult;
import com.amazonaws.services.opsworkscm.model.CreateBackupRequest;
import com.amazonaws.services.opsworkscm.model.CreateBackupResult;
import com.amazonaws.services.opsworkscm.model.CreateServerRequest;
import com.amazonaws.services.opsworkscm.model.CreateServerResult;
import com.amazonaws.services.opsworkscm.model.DeleteBackupRequest;
import com.amazonaws.services.opsworkscm.model.DeleteBackupResult;
import com.amazonaws.services.opsworkscm.model.DeleteServerRequest;
import com.amazonaws.services.opsworkscm.model.DeleteServerResult;
import com.amazonaws.services.opsworkscm.model.DescribeAccountAttributesRequest;
import com.amazonaws.services.opsworkscm.model.DescribeAccountAttributesResult;
import com.amazonaws.services.opsworkscm.model.DescribeBackupsRequest;
import com.amazonaws.services.opsworkscm.model.DescribeBackupsResult;
import com.amazonaws.services.opsworkscm.model.DescribeEventsRequest;
import com.amazonaws.services.opsworkscm.model.DescribeEventsResult;
import com.amazonaws.services.opsworkscm.model.DescribeNodeAssociationStatusRequest;
import com.amazonaws.services.opsworkscm.model.DescribeNodeAssociationStatusResult;
import com.amazonaws.services.opsworkscm.model.DescribeServersRequest;
import com.amazonaws.services.opsworkscm.model.DescribeServersResult;
import com.amazonaws.services.opsworkscm.model.DisassociateNodeRequest;
import com.amazonaws.services.opsworkscm.model.DisassociateNodeResult;
import com.amazonaws.services.opsworkscm.model.InvalidNextTokenException;
import com.amazonaws.services.opsworkscm.model.InvalidStateException;
import com.amazonaws.services.opsworkscm.model.LimitExceededException;
import com.amazonaws.services.opsworkscm.model.ResourceAlreadyExistsException;
import com.amazonaws.services.opsworkscm.model.ResourceNotFoundException;
import com.amazonaws.services.opsworkscm.model.RestoreServerRequest;
import com.amazonaws.services.opsworkscm.model.RestoreServerResult;
import com.amazonaws.services.opsworkscm.model.StartMaintenanceRequest;
import com.amazonaws.services.opsworkscm.model.StartMaintenanceResult;
import com.amazonaws.services.opsworkscm.model.UpdateServerEngineAttributesRequest;
import com.amazonaws.services.opsworkscm.model.UpdateServerEngineAttributesResult;
import com.amazonaws.services.opsworkscm.model.UpdateServerRequest;
import com.amazonaws.services.opsworkscm.model.UpdateServerResult;
import com.amazonaws.services.opsworkscm.model.ValidationException;
import com.amazonaws.services.opsworkscm.model.transform.AssociateNodeRequestProtocolMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.AssociateNodeResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.CreateBackupRequestProtocolMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.CreateBackupResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.CreateServerRequestProtocolMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.CreateServerResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DeleteBackupRequestProtocolMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DeleteBackupResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DeleteServerRequestProtocolMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DeleteServerResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeAccountAttributesRequestProtocolMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeAccountAttributesResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeBackupsRequestProtocolMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeBackupsResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeEventsRequestProtocolMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeEventsResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeNodeAssociationStatusRequestProtocolMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeNodeAssociationStatusResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeServersRequestProtocolMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeServersResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DisassociateNodeRequestProtocolMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DisassociateNodeResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.RestoreServerRequestProtocolMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.RestoreServerResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.StartMaintenanceRequestProtocolMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.StartMaintenanceResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.UpdateServerEngineAttributesRequestProtocolMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.UpdateServerEngineAttributesResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.UpdateServerRequestProtocolMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.UpdateServerResultJsonUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;

@ThreadSafe
public class AWSOpsWorksCMClient
extends AmazonWebServiceClient
implements AWSOpsWorksCM {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSOpsWorksCM.class);
    private static final String DEFAULT_SIGNING_NAME = "opsworks-cm";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withModeledClass(ValidationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(ResourceAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidStateException").withModeledClass(InvalidStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).withBaseServiceExceptionClass(AWSOpsWorksCMException.class));

    @Deprecated
    public AWSOpsWorksCMClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSOpsWorksCMClient(ClientConfiguration clientConfiguration) {
        this(DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSOpsWorksCMClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSOpsWorksCMClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AWSOpsWorksCMClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSOpsWorksCMClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSOpsWorksCMClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AWSOpsWorksCMClientBuilder builder() {
        return AWSOpsWorksCMClientBuilder.standard();
    }

    AWSOpsWorksCMClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("opsworks-cm.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/opsworkscm/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/opsworkscm/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateNodeResult associateNode(AssociateNodeRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeAssociateNode(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateNodeResult executeAssociateNode(AssociateNodeRequest associateNodeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateNodeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateNodeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateNodeRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(associateNodeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new AssociateNodeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateNodeResult associateNodeResult = (AssociateNodeResult)response.getAwsResponse();
            return associateNodeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateBackupResult createBackup(CreateBackupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateBackup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateBackupResult executeCreateBackup(CreateBackupRequest createBackupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBackupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBackupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBackupRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createBackupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateBackupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateBackupResult createBackupResult = (CreateBackupResult)response.getAwsResponse();
            return createBackupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateServerResult createServer(CreateServerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateServer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateServerResult executeCreateServer(CreateServerRequest createServerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createServerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateServerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateServerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createServerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateServerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateServerResult createServerResult = (CreateServerResult)response.getAwsResponse();
            return createServerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBackupResult deleteBackup(DeleteBackupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteBackup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBackupResult executeDeleteBackup(DeleteBackupRequest deleteBackupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBackupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBackupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteBackupRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteBackupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteBackupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteBackupResult deleteBackupResult = (DeleteBackupResult)response.getAwsResponse();
            return deleteBackupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteServerResult deleteServer(DeleteServerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteServer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteServerResult executeDeleteServer(DeleteServerRequest deleteServerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteServerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteServerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteServerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteServerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteServerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteServerResult deleteServerResult = (DeleteServerResult)response.getAwsResponse();
            return deleteServerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAccountAttributesResult describeAccountAttributes(DescribeAccountAttributesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeAccountAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAccountAttributesResult executeDescribeAccountAttributes(DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAccountAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAccountAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAccountAttributesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeAccountAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeAccountAttributesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAccountAttributesResult describeAccountAttributesResult = (DescribeAccountAttributesResult)response.getAwsResponse();
            return describeAccountAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBackupsResult describeBackups(DescribeBackupsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeBackups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeBackupsResult executeDescribeBackups(DescribeBackupsRequest describeBackupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBackupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBackupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBackupsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeBackupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeBackupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBackupsResult describeBackupsResult = (DescribeBackupsResult)response.getAwsResponse();
            return describeBackupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEventsResult describeEvents(DescribeEventsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEventsResult executeDescribeEvents(DescribeEventsRequest describeEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEventsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEventsResult describeEventsResult = (DescribeEventsResult)response.getAwsResponse();
            return describeEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeNodeAssociationStatusResult describeNodeAssociationStatus(DescribeNodeAssociationStatusRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeNodeAssociationStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeNodeAssociationStatusResult executeDescribeNodeAssociationStatus(DescribeNodeAssociationStatusRequest describeNodeAssociationStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeNodeAssociationStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeNodeAssociationStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeNodeAssociationStatusRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeNodeAssociationStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeNodeAssociationStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeNodeAssociationStatusResult describeNodeAssociationStatusResult = (DescribeNodeAssociationStatusResult)response.getAwsResponse();
            return describeNodeAssociationStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeServersResult describeServers(DescribeServersRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeServers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeServersResult executeDescribeServers(DescribeServersRequest describeServersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeServersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeServersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeServersRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeServersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeServersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeServersResult describeServersResult = (DescribeServersResult)response.getAwsResponse();
            return describeServersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateNodeResult disassociateNode(DisassociateNodeRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDisassociateNode(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateNodeResult executeDisassociateNode(DisassociateNodeRequest disassociateNodeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateNodeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateNodeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateNodeRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(disassociateNodeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DisassociateNodeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateNodeResult disassociateNodeResult = (DisassociateNodeResult)response.getAwsResponse();
            return disassociateNodeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RestoreServerResult restoreServer(RestoreServerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeRestoreServer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RestoreServerResult executeRestoreServer(RestoreServerRequest restoreServerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(restoreServerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RestoreServerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RestoreServerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(restoreServerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new RestoreServerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RestoreServerResult restoreServerResult = (RestoreServerResult)response.getAwsResponse();
            return restoreServerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartMaintenanceResult startMaintenance(StartMaintenanceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStartMaintenance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartMaintenanceResult executeStartMaintenance(StartMaintenanceRequest startMaintenanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startMaintenanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartMaintenanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartMaintenanceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(startMaintenanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StartMaintenanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartMaintenanceResult startMaintenanceResult = (StartMaintenanceResult)response.getAwsResponse();
            return startMaintenanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateServerResult updateServer(UpdateServerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateServer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateServerResult executeUpdateServer(UpdateServerRequest updateServerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateServerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateServerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateServerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateServerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateServerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateServerResult updateServerResult = (UpdateServerResult)response.getAwsResponse();
            return updateServerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateServerEngineAttributesResult updateServerEngineAttributes(UpdateServerEngineAttributesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateServerEngineAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateServerEngineAttributesResult executeUpdateServerEngineAttributes(UpdateServerEngineAttributesRequest updateServerEngineAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateServerEngineAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateServerEngineAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateServerEngineAttributesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateServerEngineAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateServerEngineAttributesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateServerEngineAttributesResult updateServerEngineAttributesResult = (UpdateServerEngineAttributesResult)response.getAwsResponse();
            return updateServerEngineAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

