/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.Application;
import com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig;
import com.amazonaws.services.elasticmapreduce.model.RepoUpgradeOnBoot;
import com.amazonaws.services.elasticmapreduce.model.ScaleDownBehavior;
import com.amazonaws.services.elasticmapreduce.model.StepConfig;
import com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig;
import com.amazonaws.services.elasticmapreduce.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RunJobFlowRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String logUri;
    private String additionalInfo;
    private String amiVersion;
    private String releaseLabel;
    private JobFlowInstancesConfig instances;
    private SdkInternalList<StepConfig> steps;
    private SdkInternalList<BootstrapActionConfig> bootstrapActions;
    private SdkInternalList<String> supportedProducts;
    private SdkInternalList<SupportedProductConfig> newSupportedProducts;
    private SdkInternalList<Application> applications;
    private SdkInternalList<Configuration> configurations;
    private Boolean visibleToAllUsers;
    private String jobFlowRole;
    private String serviceRole;
    private SdkInternalList<Tag> tags;
    private String securityConfiguration;
    private String autoScalingRole;
    private String scaleDownBehavior;
    private String customAmiId;
    private Integer ebsRootVolumeSize;
    private String repoUpgradeOnBoot;

    public RunJobFlowRequest() {
    }

    public RunJobFlowRequest(String name, JobFlowInstancesConfig instances) {
        this.setName(name);
        this.setInstances(instances);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RunJobFlowRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setLogUri(String logUri) {
        this.logUri = logUri;
    }

    public String getLogUri() {
        return this.logUri;
    }

    public RunJobFlowRequest withLogUri(String logUri) {
        this.setLogUri(logUri);
        return this;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public RunJobFlowRequest withAdditionalInfo(String additionalInfo) {
        this.setAdditionalInfo(additionalInfo);
        return this;
    }

    public void setAmiVersion(String amiVersion) {
        this.amiVersion = amiVersion;
    }

    public String getAmiVersion() {
        return this.amiVersion;
    }

    public RunJobFlowRequest withAmiVersion(String amiVersion) {
        this.setAmiVersion(amiVersion);
        return this;
    }

    public void setReleaseLabel(String releaseLabel) {
        this.releaseLabel = releaseLabel;
    }

    public String getReleaseLabel() {
        return this.releaseLabel;
    }

    public RunJobFlowRequest withReleaseLabel(String releaseLabel) {
        this.setReleaseLabel(releaseLabel);
        return this;
    }

    public void setInstances(JobFlowInstancesConfig instances) {
        this.instances = instances;
    }

    public JobFlowInstancesConfig getInstances() {
        return this.instances;
    }

    public RunJobFlowRequest withInstances(JobFlowInstancesConfig instances) {
        this.setInstances(instances);
        return this;
    }

    public List<StepConfig> getSteps() {
        if (this.steps == null) {
            this.steps = new SdkInternalList();
        }
        return this.steps;
    }

    public void setSteps(Collection<StepConfig> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }
        this.steps = new SdkInternalList<StepConfig>(steps);
    }

    public RunJobFlowRequest withSteps(StepConfig ... steps) {
        if (this.steps == null) {
            this.setSteps(new SdkInternalList<StepConfig>(steps.length));
        }
        for (StepConfig ele : steps) {
            this.steps.add(ele);
        }
        return this;
    }

    public RunJobFlowRequest withSteps(Collection<StepConfig> steps) {
        this.setSteps(steps);
        return this;
    }

    public List<BootstrapActionConfig> getBootstrapActions() {
        if (this.bootstrapActions == null) {
            this.bootstrapActions = new SdkInternalList();
        }
        return this.bootstrapActions;
    }

    public void setBootstrapActions(Collection<BootstrapActionConfig> bootstrapActions) {
        if (bootstrapActions == null) {
            this.bootstrapActions = null;
            return;
        }
        this.bootstrapActions = new SdkInternalList<BootstrapActionConfig>(bootstrapActions);
    }

    public RunJobFlowRequest withBootstrapActions(BootstrapActionConfig ... bootstrapActions) {
        if (this.bootstrapActions == null) {
            this.setBootstrapActions(new SdkInternalList<BootstrapActionConfig>(bootstrapActions.length));
        }
        for (BootstrapActionConfig ele : bootstrapActions) {
            this.bootstrapActions.add(ele);
        }
        return this;
    }

    public RunJobFlowRequest withBootstrapActions(Collection<BootstrapActionConfig> bootstrapActions) {
        this.setBootstrapActions(bootstrapActions);
        return this;
    }

    public List<String> getSupportedProducts() {
        if (this.supportedProducts == null) {
            this.supportedProducts = new SdkInternalList();
        }
        return this.supportedProducts;
    }

    public void setSupportedProducts(Collection<String> supportedProducts) {
        if (supportedProducts == null) {
            this.supportedProducts = null;
            return;
        }
        this.supportedProducts = new SdkInternalList<String>(supportedProducts);
    }

    public RunJobFlowRequest withSupportedProducts(String ... supportedProducts) {
        if (this.supportedProducts == null) {
            this.setSupportedProducts(new SdkInternalList<String>(supportedProducts.length));
        }
        for (String ele : supportedProducts) {
            this.supportedProducts.add(ele);
        }
        return this;
    }

    public RunJobFlowRequest withSupportedProducts(Collection<String> supportedProducts) {
        this.setSupportedProducts(supportedProducts);
        return this;
    }

    public List<SupportedProductConfig> getNewSupportedProducts() {
        if (this.newSupportedProducts == null) {
            this.newSupportedProducts = new SdkInternalList();
        }
        return this.newSupportedProducts;
    }

    public void setNewSupportedProducts(Collection<SupportedProductConfig> newSupportedProducts) {
        if (newSupportedProducts == null) {
            this.newSupportedProducts = null;
            return;
        }
        this.newSupportedProducts = new SdkInternalList<SupportedProductConfig>(newSupportedProducts);
    }

    public RunJobFlowRequest withNewSupportedProducts(SupportedProductConfig ... newSupportedProducts) {
        if (this.newSupportedProducts == null) {
            this.setNewSupportedProducts(new SdkInternalList<SupportedProductConfig>(newSupportedProducts.length));
        }
        for (SupportedProductConfig ele : newSupportedProducts) {
            this.newSupportedProducts.add(ele);
        }
        return this;
    }

    public RunJobFlowRequest withNewSupportedProducts(Collection<SupportedProductConfig> newSupportedProducts) {
        this.setNewSupportedProducts(newSupportedProducts);
        return this;
    }

    public List<Application> getApplications() {
        if (this.applications == null) {
            this.applications = new SdkInternalList();
        }
        return this.applications;
    }

    public void setApplications(Collection<Application> applications) {
        if (applications == null) {
            this.applications = null;
            return;
        }
        this.applications = new SdkInternalList<Application>(applications);
    }

    public RunJobFlowRequest withApplications(Application ... applications) {
        if (this.applications == null) {
            this.setApplications(new SdkInternalList<Application>(applications.length));
        }
        for (Application ele : applications) {
            this.applications.add(ele);
        }
        return this;
    }

    public RunJobFlowRequest withApplications(Collection<Application> applications) {
        this.setApplications(applications);
        return this;
    }

    public List<Configuration> getConfigurations() {
        if (this.configurations == null) {
            this.configurations = new SdkInternalList();
        }
        return this.configurations;
    }

    public void setConfigurations(Collection<Configuration> configurations) {
        if (configurations == null) {
            this.configurations = null;
            return;
        }
        this.configurations = new SdkInternalList<Configuration>(configurations);
    }

    public RunJobFlowRequest withConfigurations(Configuration ... configurations) {
        if (this.configurations == null) {
            this.setConfigurations(new SdkInternalList<Configuration>(configurations.length));
        }
        for (Configuration ele : configurations) {
            this.configurations.add(ele);
        }
        return this;
    }

    public RunJobFlowRequest withConfigurations(Collection<Configuration> configurations) {
        this.setConfigurations(configurations);
        return this;
    }

    public void setVisibleToAllUsers(Boolean visibleToAllUsers) {
        this.visibleToAllUsers = visibleToAllUsers;
    }

    public Boolean getVisibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public RunJobFlowRequest withVisibleToAllUsers(Boolean visibleToAllUsers) {
        this.setVisibleToAllUsers(visibleToAllUsers);
        return this;
    }

    public Boolean isVisibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public void setJobFlowRole(String jobFlowRole) {
        this.jobFlowRole = jobFlowRole;
    }

    public String getJobFlowRole() {
        return this.jobFlowRole;
    }

    public RunJobFlowRequest withJobFlowRole(String jobFlowRole) {
        this.setJobFlowRole(jobFlowRole);
        return this;
    }

    public void setServiceRole(String serviceRole) {
        this.serviceRole = serviceRole;
    }

    public String getServiceRole() {
        return this.serviceRole;
    }

    public RunJobFlowRequest withServiceRole(String serviceRole) {
        this.setServiceRole(serviceRole);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public RunJobFlowRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public RunJobFlowRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setSecurityConfiguration(String securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public String getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public RunJobFlowRequest withSecurityConfiguration(String securityConfiguration) {
        this.setSecurityConfiguration(securityConfiguration);
        return this;
    }

    public void setAutoScalingRole(String autoScalingRole) {
        this.autoScalingRole = autoScalingRole;
    }

    public String getAutoScalingRole() {
        return this.autoScalingRole;
    }

    public RunJobFlowRequest withAutoScalingRole(String autoScalingRole) {
        this.setAutoScalingRole(autoScalingRole);
        return this;
    }

    public void setScaleDownBehavior(String scaleDownBehavior) {
        this.scaleDownBehavior = scaleDownBehavior;
    }

    public String getScaleDownBehavior() {
        return this.scaleDownBehavior;
    }

    public RunJobFlowRequest withScaleDownBehavior(String scaleDownBehavior) {
        this.setScaleDownBehavior(scaleDownBehavior);
        return this;
    }

    public void setScaleDownBehavior(ScaleDownBehavior scaleDownBehavior) {
        this.withScaleDownBehavior(scaleDownBehavior);
    }

    public RunJobFlowRequest withScaleDownBehavior(ScaleDownBehavior scaleDownBehavior) {
        this.scaleDownBehavior = scaleDownBehavior.toString();
        return this;
    }

    public void setCustomAmiId(String customAmiId) {
        this.customAmiId = customAmiId;
    }

    public String getCustomAmiId() {
        return this.customAmiId;
    }

    public RunJobFlowRequest withCustomAmiId(String customAmiId) {
        this.setCustomAmiId(customAmiId);
        return this;
    }

    public void setEbsRootVolumeSize(Integer ebsRootVolumeSize) {
        this.ebsRootVolumeSize = ebsRootVolumeSize;
    }

    public Integer getEbsRootVolumeSize() {
        return this.ebsRootVolumeSize;
    }

    public RunJobFlowRequest withEbsRootVolumeSize(Integer ebsRootVolumeSize) {
        this.setEbsRootVolumeSize(ebsRootVolumeSize);
        return this;
    }

    public void setRepoUpgradeOnBoot(String repoUpgradeOnBoot) {
        this.repoUpgradeOnBoot = repoUpgradeOnBoot;
    }

    public String getRepoUpgradeOnBoot() {
        return this.repoUpgradeOnBoot;
    }

    public RunJobFlowRequest withRepoUpgradeOnBoot(String repoUpgradeOnBoot) {
        this.setRepoUpgradeOnBoot(repoUpgradeOnBoot);
        return this;
    }

    public void setRepoUpgradeOnBoot(RepoUpgradeOnBoot repoUpgradeOnBoot) {
        this.withRepoUpgradeOnBoot(repoUpgradeOnBoot);
    }

    public RunJobFlowRequest withRepoUpgradeOnBoot(RepoUpgradeOnBoot repoUpgradeOnBoot) {
        this.repoUpgradeOnBoot = repoUpgradeOnBoot.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getLogUri() != null) {
            sb.append("LogUri: ").append(this.getLogUri()).append(",");
        }
        if (this.getAdditionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(this.getAdditionalInfo()).append(",");
        }
        if (this.getAmiVersion() != null) {
            sb.append("AmiVersion: ").append(this.getAmiVersion()).append(",");
        }
        if (this.getReleaseLabel() != null) {
            sb.append("ReleaseLabel: ").append(this.getReleaseLabel()).append(",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: ").append(this.getInstances()).append(",");
        }
        if (this.getSteps() != null) {
            sb.append("Steps: ").append(this.getSteps()).append(",");
        }
        if (this.getBootstrapActions() != null) {
            sb.append("BootstrapActions: ").append(this.getBootstrapActions()).append(",");
        }
        if (this.getSupportedProducts() != null) {
            sb.append("SupportedProducts: ").append(this.getSupportedProducts()).append(",");
        }
        if (this.getNewSupportedProducts() != null) {
            sb.append("NewSupportedProducts: ").append(this.getNewSupportedProducts()).append(",");
        }
        if (this.getApplications() != null) {
            sb.append("Applications: ").append(this.getApplications()).append(",");
        }
        if (this.getConfigurations() != null) {
            sb.append("Configurations: ").append(this.getConfigurations()).append(",");
        }
        if (this.getVisibleToAllUsers() != null) {
            sb.append("VisibleToAllUsers: ").append(this.getVisibleToAllUsers()).append(",");
        }
        if (this.getJobFlowRole() != null) {
            sb.append("JobFlowRole: ").append(this.getJobFlowRole()).append(",");
        }
        if (this.getServiceRole() != null) {
            sb.append("ServiceRole: ").append(this.getServiceRole()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getSecurityConfiguration() != null) {
            sb.append("SecurityConfiguration: ").append(this.getSecurityConfiguration()).append(",");
        }
        if (this.getAutoScalingRole() != null) {
            sb.append("AutoScalingRole: ").append(this.getAutoScalingRole()).append(",");
        }
        if (this.getScaleDownBehavior() != null) {
            sb.append("ScaleDownBehavior: ").append(this.getScaleDownBehavior()).append(",");
        }
        if (this.getCustomAmiId() != null) {
            sb.append("CustomAmiId: ").append(this.getCustomAmiId()).append(",");
        }
        if (this.getEbsRootVolumeSize() != null) {
            sb.append("EbsRootVolumeSize: ").append(this.getEbsRootVolumeSize()).append(",");
        }
        if (this.getRepoUpgradeOnBoot() != null) {
            sb.append("RepoUpgradeOnBoot: ").append(this.getRepoUpgradeOnBoot());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunJobFlowRequest)) {
            return false;
        }
        RunJobFlowRequest other = (RunJobFlowRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getLogUri() == null ^ this.getLogUri() == null) {
            return false;
        }
        if (other.getLogUri() != null && !other.getLogUri().equals(this.getLogUri())) {
            return false;
        }
        if (other.getAdditionalInfo() == null ^ this.getAdditionalInfo() == null) {
            return false;
        }
        if (other.getAdditionalInfo() != null && !other.getAdditionalInfo().equals(this.getAdditionalInfo())) {
            return false;
        }
        if (other.getAmiVersion() == null ^ this.getAmiVersion() == null) {
            return false;
        }
        if (other.getAmiVersion() != null && !other.getAmiVersion().equals(this.getAmiVersion())) {
            return false;
        }
        if (other.getReleaseLabel() == null ^ this.getReleaseLabel() == null) {
            return false;
        }
        if (other.getReleaseLabel() != null && !other.getReleaseLabel().equals(this.getReleaseLabel())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getSteps() == null ^ this.getSteps() == null) {
            return false;
        }
        if (other.getSteps() != null && !other.getSteps().equals(this.getSteps())) {
            return false;
        }
        if (other.getBootstrapActions() == null ^ this.getBootstrapActions() == null) {
            return false;
        }
        if (other.getBootstrapActions() != null && !other.getBootstrapActions().equals(this.getBootstrapActions())) {
            return false;
        }
        if (other.getSupportedProducts() == null ^ this.getSupportedProducts() == null) {
            return false;
        }
        if (other.getSupportedProducts() != null && !other.getSupportedProducts().equals(this.getSupportedProducts())) {
            return false;
        }
        if (other.getNewSupportedProducts() == null ^ this.getNewSupportedProducts() == null) {
            return false;
        }
        if (other.getNewSupportedProducts() != null && !other.getNewSupportedProducts().equals(this.getNewSupportedProducts())) {
            return false;
        }
        if (other.getApplications() == null ^ this.getApplications() == null) {
            return false;
        }
        if (other.getApplications() != null && !other.getApplications().equals(this.getApplications())) {
            return false;
        }
        if (other.getConfigurations() == null ^ this.getConfigurations() == null) {
            return false;
        }
        if (other.getConfigurations() != null && !other.getConfigurations().equals(this.getConfigurations())) {
            return false;
        }
        if (other.getVisibleToAllUsers() == null ^ this.getVisibleToAllUsers() == null) {
            return false;
        }
        if (other.getVisibleToAllUsers() != null && !other.getVisibleToAllUsers().equals(this.getVisibleToAllUsers())) {
            return false;
        }
        if (other.getJobFlowRole() == null ^ this.getJobFlowRole() == null) {
            return false;
        }
        if (other.getJobFlowRole() != null && !other.getJobFlowRole().equals(this.getJobFlowRole())) {
            return false;
        }
        if (other.getServiceRole() == null ^ this.getServiceRole() == null) {
            return false;
        }
        if (other.getServiceRole() != null && !other.getServiceRole().equals(this.getServiceRole())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getSecurityConfiguration() == null ^ this.getSecurityConfiguration() == null) {
            return false;
        }
        if (other.getSecurityConfiguration() != null && !other.getSecurityConfiguration().equals(this.getSecurityConfiguration())) {
            return false;
        }
        if (other.getAutoScalingRole() == null ^ this.getAutoScalingRole() == null) {
            return false;
        }
        if (other.getAutoScalingRole() != null && !other.getAutoScalingRole().equals(this.getAutoScalingRole())) {
            return false;
        }
        if (other.getScaleDownBehavior() == null ^ this.getScaleDownBehavior() == null) {
            return false;
        }
        if (other.getScaleDownBehavior() != null && !other.getScaleDownBehavior().equals(this.getScaleDownBehavior())) {
            return false;
        }
        if (other.getCustomAmiId() == null ^ this.getCustomAmiId() == null) {
            return false;
        }
        if (other.getCustomAmiId() != null && !other.getCustomAmiId().equals(this.getCustomAmiId())) {
            return false;
        }
        if (other.getEbsRootVolumeSize() == null ^ this.getEbsRootVolumeSize() == null) {
            return false;
        }
        if (other.getEbsRootVolumeSize() != null && !other.getEbsRootVolumeSize().equals(this.getEbsRootVolumeSize())) {
            return false;
        }
        if (other.getRepoUpgradeOnBoot() == null ^ this.getRepoUpgradeOnBoot() == null) {
            return false;
        }
        return other.getRepoUpgradeOnBoot() == null || other.getRepoUpgradeOnBoot().equals(this.getRepoUpgradeOnBoot());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getLogUri() == null ? 0 : this.getLogUri().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalInfo() == null ? 0 : this.getAdditionalInfo().hashCode());
        hashCode = 31 * hashCode + (this.getAmiVersion() == null ? 0 : this.getAmiVersion().hashCode());
        hashCode = 31 * hashCode + (this.getReleaseLabel() == null ? 0 : this.getReleaseLabel().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getSteps() == null ? 0 : this.getSteps().hashCode());
        hashCode = 31 * hashCode + (this.getBootstrapActions() == null ? 0 : this.getBootstrapActions().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedProducts() == null ? 0 : this.getSupportedProducts().hashCode());
        hashCode = 31 * hashCode + (this.getNewSupportedProducts() == null ? 0 : this.getNewSupportedProducts().hashCode());
        hashCode = 31 * hashCode + (this.getApplications() == null ? 0 : this.getApplications().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurations() == null ? 0 : this.getConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getVisibleToAllUsers() == null ? 0 : this.getVisibleToAllUsers().hashCode());
        hashCode = 31 * hashCode + (this.getJobFlowRole() == null ? 0 : this.getJobFlowRole().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRole() == null ? 0 : this.getServiceRole().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityConfiguration() == null ? 0 : this.getSecurityConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingRole() == null ? 0 : this.getAutoScalingRole().hashCode());
        hashCode = 31 * hashCode + (this.getScaleDownBehavior() == null ? 0 : this.getScaleDownBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getCustomAmiId() == null ? 0 : this.getCustomAmiId().hashCode());
        hashCode = 31 * hashCode + (this.getEbsRootVolumeSize() == null ? 0 : this.getEbsRootVolumeSize().hashCode());
        hashCode = 31 * hashCode + (this.getRepoUpgradeOnBoot() == null ? 0 : this.getRepoUpgradeOnBoot().hashCode());
        return hashCode;
    }

    @Override
    public RunJobFlowRequest clone() {
        return (RunJobFlowRequest)super.clone();
    }
}

