/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.athena.model.Datum;

@SdkInternalApi
public class DatumMarshaller {
    private static final MarshallingInfo<String> VARCHARVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VarCharValue").build();
    private static final DatumMarshaller instance = new DatumMarshaller();

    public static DatumMarshaller getInstance() {
        return instance;
    }

    public void marshall(Datum datum, ProtocolMarshaller protocolMarshaller) {
        if (datum == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(datum.getVarCharValue(), VARCHARVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

