/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cognitoidentity.model.MappingRuleMatchType;
import com.amazonaws.services.cognitoidentity.model.transform.MappingRuleMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;

public class MappingRule
implements Serializable,
Cloneable,
StructuredPojo {
    private String claim;
    private String matchType;
    private String value;
    private String roleARN;

    public void setClaim(String claim) {
        this.claim = claim;
    }

    public String getClaim() {
        return this.claim;
    }

    public MappingRule withClaim(String claim) {
        this.setClaim(claim);
        return this;
    }

    public void setMatchType(String matchType) {
        this.matchType = matchType;
    }

    @JsonProperty(value="matchType")
    public String getMatchType() {
        return this.matchType;
    }

    public MappingRule withMatchType(String matchType) {
        this.setMatchType(matchType);
        return this;
    }

    @JsonIgnore
    public void setMatchType(MappingRuleMatchType matchType) {
        this.withMatchType(matchType);
    }

    public MappingRule withMatchType(MappingRuleMatchType matchType) {
        this.matchType = matchType.toString();
        return this;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public MappingRule withValue(String value) {
        this.setValue(value);
        return this;
    }

    public void setRoleARN(String roleARN) {
        this.roleARN = roleARN;
    }

    public String getRoleARN() {
        return this.roleARN;
    }

    public MappingRule withRoleARN(String roleARN) {
        this.setRoleARN(roleARN);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClaim() != null) {
            sb.append("Claim: ").append(this.getClaim()).append(",");
        }
        if (this.getMatchType() != null) {
            sb.append("MatchType: ").append(this.getMatchType()).append(",");
        }
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getRoleARN() != null) {
            sb.append("RoleARN: ").append(this.getRoleARN());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappingRule)) {
            return false;
        }
        MappingRule other = (MappingRule)obj;
        if (other.getClaim() == null ^ this.getClaim() == null) {
            return false;
        }
        if (other.getClaim() != null && !other.getClaim().equals(this.getClaim())) {
            return false;
        }
        if (other.getMatchType() == null ^ this.getMatchType() == null) {
            return false;
        }
        if (other.getMatchType() != null && !other.getMatchType().equals(this.getMatchType())) {
            return false;
        }
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getRoleARN() == null ^ this.getRoleARN() == null) {
            return false;
        }
        return other.getRoleARN() == null || other.getRoleARN().equals(this.getRoleARN());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClaim() == null ? 0 : this.getClaim().hashCode());
        hashCode = 31 * hashCode + (this.getMatchType() == null ? 0 : this.getMatchType().hashCode());
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getRoleARN() == null ? 0 : this.getRoleARN().hashCode());
        return hashCode;
    }

    public MappingRule clone() {
        try {
            return (MappingRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MappingRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

