/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.AutomaticFailoverStatus;
import com.amazonaws.services.elasticache.model.Endpoint;
import com.amazonaws.services.elasticache.model.NodeGroup;
import com.amazonaws.services.elasticache.model.ReplicationGroupPendingModifiedValues;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ReplicationGroup
implements Serializable,
Cloneable {
    private String replicationGroupId;
    private String description;
    private String status;
    private ReplicationGroupPendingModifiedValues pendingModifiedValues;
    private SdkInternalList<String> memberClusters;
    private SdkInternalList<NodeGroup> nodeGroups;
    private String snapshottingClusterId;
    private String automaticFailover;
    private Endpoint configurationEndpoint;
    private Integer snapshotRetentionLimit;
    private String snapshotWindow;
    private Boolean clusterEnabled;
    private String cacheNodeType;

    public void setReplicationGroupId(String replicationGroupId) {
        this.replicationGroupId = replicationGroupId;
    }

    public String getReplicationGroupId() {
        return this.replicationGroupId;
    }

    public ReplicationGroup withReplicationGroupId(String replicationGroupId) {
        this.setReplicationGroupId(replicationGroupId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ReplicationGroup withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public ReplicationGroup withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setPendingModifiedValues(ReplicationGroupPendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public ReplicationGroupPendingModifiedValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public ReplicationGroup withPendingModifiedValues(ReplicationGroupPendingModifiedValues pendingModifiedValues) {
        this.setPendingModifiedValues(pendingModifiedValues);
        return this;
    }

    public List<String> getMemberClusters() {
        if (this.memberClusters == null) {
            this.memberClusters = new SdkInternalList();
        }
        return this.memberClusters;
    }

    public void setMemberClusters(Collection<String> memberClusters) {
        if (memberClusters == null) {
            this.memberClusters = null;
            return;
        }
        this.memberClusters = new SdkInternalList<String>(memberClusters);
    }

    public ReplicationGroup withMemberClusters(String ... memberClusters) {
        if (this.memberClusters == null) {
            this.setMemberClusters(new SdkInternalList<String>(memberClusters.length));
        }
        for (String ele : memberClusters) {
            this.memberClusters.add(ele);
        }
        return this;
    }

    public ReplicationGroup withMemberClusters(Collection<String> memberClusters) {
        this.setMemberClusters(memberClusters);
        return this;
    }

    public List<NodeGroup> getNodeGroups() {
        if (this.nodeGroups == null) {
            this.nodeGroups = new SdkInternalList();
        }
        return this.nodeGroups;
    }

    public void setNodeGroups(Collection<NodeGroup> nodeGroups) {
        if (nodeGroups == null) {
            this.nodeGroups = null;
            return;
        }
        this.nodeGroups = new SdkInternalList<NodeGroup>(nodeGroups);
    }

    public ReplicationGroup withNodeGroups(NodeGroup ... nodeGroups) {
        if (this.nodeGroups == null) {
            this.setNodeGroups(new SdkInternalList<NodeGroup>(nodeGroups.length));
        }
        for (NodeGroup ele : nodeGroups) {
            this.nodeGroups.add(ele);
        }
        return this;
    }

    public ReplicationGroup withNodeGroups(Collection<NodeGroup> nodeGroups) {
        this.setNodeGroups(nodeGroups);
        return this;
    }

    public void setSnapshottingClusterId(String snapshottingClusterId) {
        this.snapshottingClusterId = snapshottingClusterId;
    }

    public String getSnapshottingClusterId() {
        return this.snapshottingClusterId;
    }

    public ReplicationGroup withSnapshottingClusterId(String snapshottingClusterId) {
        this.setSnapshottingClusterId(snapshottingClusterId);
        return this;
    }

    public void setAutomaticFailover(String automaticFailover) {
        this.automaticFailover = automaticFailover;
    }

    @JsonProperty(value="automaticFailover")
    public String getAutomaticFailover() {
        return this.automaticFailover;
    }

    public ReplicationGroup withAutomaticFailover(String automaticFailover) {
        this.setAutomaticFailover(automaticFailover);
        return this;
    }

    @JsonIgnore
    public void setAutomaticFailover(AutomaticFailoverStatus automaticFailover) {
        this.withAutomaticFailover(automaticFailover);
    }

    public ReplicationGroup withAutomaticFailover(AutomaticFailoverStatus automaticFailover) {
        this.automaticFailover = automaticFailover.toString();
        return this;
    }

    public void setConfigurationEndpoint(Endpoint configurationEndpoint) {
        this.configurationEndpoint = configurationEndpoint;
    }

    public Endpoint getConfigurationEndpoint() {
        return this.configurationEndpoint;
    }

    public ReplicationGroup withConfigurationEndpoint(Endpoint configurationEndpoint) {
        this.setConfigurationEndpoint(configurationEndpoint);
        return this;
    }

    public void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.snapshotRetentionLimit = snapshotRetentionLimit;
    }

    public Integer getSnapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public ReplicationGroup withSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.setSnapshotRetentionLimit(snapshotRetentionLimit);
        return this;
    }

    public void setSnapshotWindow(String snapshotWindow) {
        this.snapshotWindow = snapshotWindow;
    }

    public String getSnapshotWindow() {
        return this.snapshotWindow;
    }

    public ReplicationGroup withSnapshotWindow(String snapshotWindow) {
        this.setSnapshotWindow(snapshotWindow);
        return this;
    }

    public void setClusterEnabled(Boolean clusterEnabled) {
        this.clusterEnabled = clusterEnabled;
    }

    public Boolean getClusterEnabled() {
        return this.clusterEnabled;
    }

    public ReplicationGroup withClusterEnabled(Boolean clusterEnabled) {
        this.setClusterEnabled(clusterEnabled);
        return this;
    }

    public Boolean isClusterEnabled() {
        return this.clusterEnabled;
    }

    public void setCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
    }

    public String getCacheNodeType() {
        return this.cacheNodeType;
    }

    public ReplicationGroup withCacheNodeType(String cacheNodeType) {
        this.setCacheNodeType(cacheNodeType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReplicationGroupId() != null) {
            sb.append("ReplicationGroupId: ").append(this.getReplicationGroupId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getPendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: ").append(this.getPendingModifiedValues()).append(",");
        }
        if (this.getMemberClusters() != null) {
            sb.append("MemberClusters: ").append(this.getMemberClusters()).append(",");
        }
        if (this.getNodeGroups() != null) {
            sb.append("NodeGroups: ").append(this.getNodeGroups()).append(",");
        }
        if (this.getSnapshottingClusterId() != null) {
            sb.append("SnapshottingClusterId: ").append(this.getSnapshottingClusterId()).append(",");
        }
        if (this.getAutomaticFailover() != null) {
            sb.append("AutomaticFailover: ").append(this.getAutomaticFailover()).append(",");
        }
        if (this.getConfigurationEndpoint() != null) {
            sb.append("ConfigurationEndpoint: ").append(this.getConfigurationEndpoint()).append(",");
        }
        if (this.getSnapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: ").append(this.getSnapshotRetentionLimit()).append(",");
        }
        if (this.getSnapshotWindow() != null) {
            sb.append("SnapshotWindow: ").append(this.getSnapshotWindow()).append(",");
        }
        if (this.getClusterEnabled() != null) {
            sb.append("ClusterEnabled: ").append(this.getClusterEnabled()).append(",");
        }
        if (this.getCacheNodeType() != null) {
            sb.append("CacheNodeType: ").append(this.getCacheNodeType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroup)) {
            return false;
        }
        ReplicationGroup other = (ReplicationGroup)obj;
        if (other.getReplicationGroupId() == null ^ this.getReplicationGroupId() == null) {
            return false;
        }
        if (other.getReplicationGroupId() != null && !other.getReplicationGroupId().equals(this.getReplicationGroupId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getPendingModifiedValues() == null ^ this.getPendingModifiedValues() == null) {
            return false;
        }
        if (other.getPendingModifiedValues() != null && !other.getPendingModifiedValues().equals(this.getPendingModifiedValues())) {
            return false;
        }
        if (other.getMemberClusters() == null ^ this.getMemberClusters() == null) {
            return false;
        }
        if (other.getMemberClusters() != null && !other.getMemberClusters().equals(this.getMemberClusters())) {
            return false;
        }
        if (other.getNodeGroups() == null ^ this.getNodeGroups() == null) {
            return false;
        }
        if (other.getNodeGroups() != null && !other.getNodeGroups().equals(this.getNodeGroups())) {
            return false;
        }
        if (other.getSnapshottingClusterId() == null ^ this.getSnapshottingClusterId() == null) {
            return false;
        }
        if (other.getSnapshottingClusterId() != null && !other.getSnapshottingClusterId().equals(this.getSnapshottingClusterId())) {
            return false;
        }
        if (other.getAutomaticFailover() == null ^ this.getAutomaticFailover() == null) {
            return false;
        }
        if (other.getAutomaticFailover() != null && !other.getAutomaticFailover().equals(this.getAutomaticFailover())) {
            return false;
        }
        if (other.getConfigurationEndpoint() == null ^ this.getConfigurationEndpoint() == null) {
            return false;
        }
        if (other.getConfigurationEndpoint() != null && !other.getConfigurationEndpoint().equals(this.getConfigurationEndpoint())) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() == null ^ this.getSnapshotRetentionLimit() == null) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() != null && !other.getSnapshotRetentionLimit().equals(this.getSnapshotRetentionLimit())) {
            return false;
        }
        if (other.getSnapshotWindow() == null ^ this.getSnapshotWindow() == null) {
            return false;
        }
        if (other.getSnapshotWindow() != null && !other.getSnapshotWindow().equals(this.getSnapshotWindow())) {
            return false;
        }
        if (other.getClusterEnabled() == null ^ this.getClusterEnabled() == null) {
            return false;
        }
        if (other.getClusterEnabled() != null && !other.getClusterEnabled().equals(this.getClusterEnabled())) {
            return false;
        }
        if (other.getCacheNodeType() == null ^ this.getCacheNodeType() == null) {
            return false;
        }
        return other.getCacheNodeType() == null || other.getCacheNodeType().equals(this.getCacheNodeType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReplicationGroupId() == null ? 0 : this.getReplicationGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPendingModifiedValues() == null ? 0 : this.getPendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.getMemberClusters() == null ? 0 : this.getMemberClusters().hashCode());
        hashCode = 31 * hashCode + (this.getNodeGroups() == null ? 0 : this.getNodeGroups().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshottingClusterId() == null ? 0 : this.getSnapshottingClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getAutomaticFailover() == null ? 0 : this.getAutomaticFailover().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationEndpoint() == null ? 0 : this.getConfigurationEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotRetentionLimit() == null ? 0 : this.getSnapshotRetentionLimit().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotWindow() == null ? 0 : this.getSnapshotWindow().hashCode());
        hashCode = 31 * hashCode + (this.getClusterEnabled() == null ? 0 : this.getClusterEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodeType() == null ? 0 : this.getCacheNodeType().hashCode());
        return hashCode;
    }

    public ReplicationGroup clone() {
        try {
            return (ReplicationGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

