/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.gamelift.model.DesiredPlayerSession;
import com.amazonaws.services.gamelift.model.GameProperty;
import com.amazonaws.services.gamelift.model.PlayerLatency;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartGameSessionPlacementRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String placementId;
    private String gameSessionQueueName;
    private List<GameProperty> gameProperties;
    private Integer maximumPlayerSessionCount;
    private String gameSessionName;
    private List<PlayerLatency> playerLatencies;
    private List<DesiredPlayerSession> desiredPlayerSessions;
    private String gameSessionData;

    public void setPlacementId(String placementId) {
        this.placementId = placementId;
    }

    public String getPlacementId() {
        return this.placementId;
    }

    public StartGameSessionPlacementRequest withPlacementId(String placementId) {
        this.setPlacementId(placementId);
        return this;
    }

    public void setGameSessionQueueName(String gameSessionQueueName) {
        this.gameSessionQueueName = gameSessionQueueName;
    }

    public String getGameSessionQueueName() {
        return this.gameSessionQueueName;
    }

    public StartGameSessionPlacementRequest withGameSessionQueueName(String gameSessionQueueName) {
        this.setGameSessionQueueName(gameSessionQueueName);
        return this;
    }

    public List<GameProperty> getGameProperties() {
        return this.gameProperties;
    }

    public void setGameProperties(Collection<GameProperty> gameProperties) {
        if (gameProperties == null) {
            this.gameProperties = null;
            return;
        }
        this.gameProperties = new ArrayList<GameProperty>(gameProperties);
    }

    public StartGameSessionPlacementRequest withGameProperties(GameProperty ... gameProperties) {
        if (this.gameProperties == null) {
            this.setGameProperties(new ArrayList<GameProperty>(gameProperties.length));
        }
        for (GameProperty ele : gameProperties) {
            this.gameProperties.add(ele);
        }
        return this;
    }

    public StartGameSessionPlacementRequest withGameProperties(Collection<GameProperty> gameProperties) {
        this.setGameProperties(gameProperties);
        return this;
    }

    public void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
        this.maximumPlayerSessionCount = maximumPlayerSessionCount;
    }

    public Integer getMaximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public StartGameSessionPlacementRequest withMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
        this.setMaximumPlayerSessionCount(maximumPlayerSessionCount);
        return this;
    }

    public void setGameSessionName(String gameSessionName) {
        this.gameSessionName = gameSessionName;
    }

    public String getGameSessionName() {
        return this.gameSessionName;
    }

    public StartGameSessionPlacementRequest withGameSessionName(String gameSessionName) {
        this.setGameSessionName(gameSessionName);
        return this;
    }

    public List<PlayerLatency> getPlayerLatencies() {
        return this.playerLatencies;
    }

    public void setPlayerLatencies(Collection<PlayerLatency> playerLatencies) {
        if (playerLatencies == null) {
            this.playerLatencies = null;
            return;
        }
        this.playerLatencies = new ArrayList<PlayerLatency>(playerLatencies);
    }

    public StartGameSessionPlacementRequest withPlayerLatencies(PlayerLatency ... playerLatencies) {
        if (this.playerLatencies == null) {
            this.setPlayerLatencies(new ArrayList<PlayerLatency>(playerLatencies.length));
        }
        for (PlayerLatency ele : playerLatencies) {
            this.playerLatencies.add(ele);
        }
        return this;
    }

    public StartGameSessionPlacementRequest withPlayerLatencies(Collection<PlayerLatency> playerLatencies) {
        this.setPlayerLatencies(playerLatencies);
        return this;
    }

    public List<DesiredPlayerSession> getDesiredPlayerSessions() {
        return this.desiredPlayerSessions;
    }

    public void setDesiredPlayerSessions(Collection<DesiredPlayerSession> desiredPlayerSessions) {
        if (desiredPlayerSessions == null) {
            this.desiredPlayerSessions = null;
            return;
        }
        this.desiredPlayerSessions = new ArrayList<DesiredPlayerSession>(desiredPlayerSessions);
    }

    public StartGameSessionPlacementRequest withDesiredPlayerSessions(DesiredPlayerSession ... desiredPlayerSessions) {
        if (this.desiredPlayerSessions == null) {
            this.setDesiredPlayerSessions(new ArrayList<DesiredPlayerSession>(desiredPlayerSessions.length));
        }
        for (DesiredPlayerSession ele : desiredPlayerSessions) {
            this.desiredPlayerSessions.add(ele);
        }
        return this;
    }

    public StartGameSessionPlacementRequest withDesiredPlayerSessions(Collection<DesiredPlayerSession> desiredPlayerSessions) {
        this.setDesiredPlayerSessions(desiredPlayerSessions);
        return this;
    }

    public void setGameSessionData(String gameSessionData) {
        this.gameSessionData = gameSessionData;
    }

    public String getGameSessionData() {
        return this.gameSessionData;
    }

    public StartGameSessionPlacementRequest withGameSessionData(String gameSessionData) {
        this.setGameSessionData(gameSessionData);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPlacementId() != null) {
            sb.append("PlacementId: ").append(this.getPlacementId()).append(",");
        }
        if (this.getGameSessionQueueName() != null) {
            sb.append("GameSessionQueueName: ").append(this.getGameSessionQueueName()).append(",");
        }
        if (this.getGameProperties() != null) {
            sb.append("GameProperties: ").append(this.getGameProperties()).append(",");
        }
        if (this.getMaximumPlayerSessionCount() != null) {
            sb.append("MaximumPlayerSessionCount: ").append(this.getMaximumPlayerSessionCount()).append(",");
        }
        if (this.getGameSessionName() != null) {
            sb.append("GameSessionName: ").append(this.getGameSessionName()).append(",");
        }
        if (this.getPlayerLatencies() != null) {
            sb.append("PlayerLatencies: ").append(this.getPlayerLatencies()).append(",");
        }
        if (this.getDesiredPlayerSessions() != null) {
            sb.append("DesiredPlayerSessions: ").append(this.getDesiredPlayerSessions()).append(",");
        }
        if (this.getGameSessionData() != null) {
            sb.append("GameSessionData: ").append(this.getGameSessionData());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartGameSessionPlacementRequest)) {
            return false;
        }
        StartGameSessionPlacementRequest other = (StartGameSessionPlacementRequest)obj;
        if (other.getPlacementId() == null ^ this.getPlacementId() == null) {
            return false;
        }
        if (other.getPlacementId() != null && !other.getPlacementId().equals(this.getPlacementId())) {
            return false;
        }
        if (other.getGameSessionQueueName() == null ^ this.getGameSessionQueueName() == null) {
            return false;
        }
        if (other.getGameSessionQueueName() != null && !other.getGameSessionQueueName().equals(this.getGameSessionQueueName())) {
            return false;
        }
        if (other.getGameProperties() == null ^ this.getGameProperties() == null) {
            return false;
        }
        if (other.getGameProperties() != null && !other.getGameProperties().equals(this.getGameProperties())) {
            return false;
        }
        if (other.getMaximumPlayerSessionCount() == null ^ this.getMaximumPlayerSessionCount() == null) {
            return false;
        }
        if (other.getMaximumPlayerSessionCount() != null && !other.getMaximumPlayerSessionCount().equals(this.getMaximumPlayerSessionCount())) {
            return false;
        }
        if (other.getGameSessionName() == null ^ this.getGameSessionName() == null) {
            return false;
        }
        if (other.getGameSessionName() != null && !other.getGameSessionName().equals(this.getGameSessionName())) {
            return false;
        }
        if (other.getPlayerLatencies() == null ^ this.getPlayerLatencies() == null) {
            return false;
        }
        if (other.getPlayerLatencies() != null && !other.getPlayerLatencies().equals(this.getPlayerLatencies())) {
            return false;
        }
        if (other.getDesiredPlayerSessions() == null ^ this.getDesiredPlayerSessions() == null) {
            return false;
        }
        if (other.getDesiredPlayerSessions() != null && !other.getDesiredPlayerSessions().equals(this.getDesiredPlayerSessions())) {
            return false;
        }
        if (other.getGameSessionData() == null ^ this.getGameSessionData() == null) {
            return false;
        }
        return other.getGameSessionData() == null || other.getGameSessionData().equals(this.getGameSessionData());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPlacementId() == null ? 0 : this.getPlacementId().hashCode());
        hashCode = 31 * hashCode + (this.getGameSessionQueueName() == null ? 0 : this.getGameSessionQueueName().hashCode());
        hashCode = 31 * hashCode + (this.getGameProperties() == null ? 0 : this.getGameProperties().hashCode());
        hashCode = 31 * hashCode + (this.getMaximumPlayerSessionCount() == null ? 0 : this.getMaximumPlayerSessionCount().hashCode());
        hashCode = 31 * hashCode + (this.getGameSessionName() == null ? 0 : this.getGameSessionName().hashCode());
        hashCode = 31 * hashCode + (this.getPlayerLatencies() == null ? 0 : this.getPlayerLatencies().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredPlayerSessions() == null ? 0 : this.getDesiredPlayerSessions().hashCode());
        hashCode = 31 * hashCode + (this.getGameSessionData() == null ? 0 : this.getGameSessionData().hashCode());
        return hashCode;
    }

    @Override
    public StartGameSessionPlacementRequest clone() {
        return (StartGameSessionPlacementRequest)super.clone();
    }
}

