/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costandusagereport.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.costandusagereport.model.AWSRegion;
import com.amazonaws.services.costandusagereport.model.AdditionalArtifact;
import com.amazonaws.services.costandusagereport.model.CompressionFormat;
import com.amazonaws.services.costandusagereport.model.ReportFormat;
import com.amazonaws.services.costandusagereport.model.SchemaElement;
import com.amazonaws.services.costandusagereport.model.TimeUnit;
import com.amazonaws.services.costandusagereport.model.transform.ReportDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReportDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String reportName;
    private String timeUnit;
    private String format;
    private String compression;
    private List<String> additionalSchemaElements;
    private String s3Bucket;
    private String s3Prefix;
    private String s3Region;
    private List<String> additionalArtifacts;

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String getReportName() {
        return this.reportName;
    }

    public ReportDefinition withReportName(String reportName) {
        this.setReportName(reportName);
        return this;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public ReportDefinition withTimeUnit(String timeUnit) {
        this.setTimeUnit(timeUnit);
        return this;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.withTimeUnit(timeUnit);
    }

    public ReportDefinition withTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit.toString();
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public ReportDefinition withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public void setFormat(ReportFormat format) {
        this.withFormat(format);
    }

    public ReportDefinition withFormat(ReportFormat format) {
        this.format = format.toString();
        return this;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getCompression() {
        return this.compression;
    }

    public ReportDefinition withCompression(String compression) {
        this.setCompression(compression);
        return this;
    }

    public void setCompression(CompressionFormat compression) {
        this.withCompression(compression);
    }

    public ReportDefinition withCompression(CompressionFormat compression) {
        this.compression = compression.toString();
        return this;
    }

    public List<String> getAdditionalSchemaElements() {
        return this.additionalSchemaElements;
    }

    public void setAdditionalSchemaElements(Collection<String> additionalSchemaElements) {
        if (additionalSchemaElements == null) {
            this.additionalSchemaElements = null;
            return;
        }
        this.additionalSchemaElements = new ArrayList<String>(additionalSchemaElements);
    }

    public ReportDefinition withAdditionalSchemaElements(String ... additionalSchemaElements) {
        if (this.additionalSchemaElements == null) {
            this.setAdditionalSchemaElements(new ArrayList<String>(additionalSchemaElements.length));
        }
        for (String ele : additionalSchemaElements) {
            this.additionalSchemaElements.add(ele);
        }
        return this;
    }

    public ReportDefinition withAdditionalSchemaElements(Collection<String> additionalSchemaElements) {
        this.setAdditionalSchemaElements(additionalSchemaElements);
        return this;
    }

    public ReportDefinition withAdditionalSchemaElements(SchemaElement ... additionalSchemaElements) {
        ArrayList<String> additionalSchemaElementsCopy = new ArrayList<String>(additionalSchemaElements.length);
        for (SchemaElement value : additionalSchemaElements) {
            additionalSchemaElementsCopy.add(value.toString());
        }
        if (this.getAdditionalSchemaElements() == null) {
            this.setAdditionalSchemaElements(additionalSchemaElementsCopy);
        } else {
            this.getAdditionalSchemaElements().addAll(additionalSchemaElementsCopy);
        }
        return this;
    }

    public void setS3Bucket(String s3Bucket) {
        this.s3Bucket = s3Bucket;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public ReportDefinition withS3Bucket(String s3Bucket) {
        this.setS3Bucket(s3Bucket);
        return this;
    }

    public void setS3Prefix(String s3Prefix) {
        this.s3Prefix = s3Prefix;
    }

    public String getS3Prefix() {
        return this.s3Prefix;
    }

    public ReportDefinition withS3Prefix(String s3Prefix) {
        this.setS3Prefix(s3Prefix);
        return this;
    }

    public void setS3Region(String s3Region) {
        this.s3Region = s3Region;
    }

    public String getS3Region() {
        return this.s3Region;
    }

    public ReportDefinition withS3Region(String s3Region) {
        this.setS3Region(s3Region);
        return this;
    }

    public void setS3Region(AWSRegion s3Region) {
        this.withS3Region(s3Region);
    }

    public ReportDefinition withS3Region(AWSRegion s3Region) {
        this.s3Region = s3Region.toString();
        return this;
    }

    public List<String> getAdditionalArtifacts() {
        return this.additionalArtifacts;
    }

    public void setAdditionalArtifacts(Collection<String> additionalArtifacts) {
        if (additionalArtifacts == null) {
            this.additionalArtifacts = null;
            return;
        }
        this.additionalArtifacts = new ArrayList<String>(additionalArtifacts);
    }

    public ReportDefinition withAdditionalArtifacts(String ... additionalArtifacts) {
        if (this.additionalArtifacts == null) {
            this.setAdditionalArtifacts(new ArrayList<String>(additionalArtifacts.length));
        }
        for (String ele : additionalArtifacts) {
            this.additionalArtifacts.add(ele);
        }
        return this;
    }

    public ReportDefinition withAdditionalArtifacts(Collection<String> additionalArtifacts) {
        this.setAdditionalArtifacts(additionalArtifacts);
        return this;
    }

    public ReportDefinition withAdditionalArtifacts(AdditionalArtifact ... additionalArtifacts) {
        ArrayList<String> additionalArtifactsCopy = new ArrayList<String>(additionalArtifacts.length);
        for (AdditionalArtifact value : additionalArtifacts) {
            additionalArtifactsCopy.add(value.toString());
        }
        if (this.getAdditionalArtifacts() == null) {
            this.setAdditionalArtifacts(additionalArtifactsCopy);
        } else {
            this.getAdditionalArtifacts().addAll(additionalArtifactsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReportName() != null) {
            sb.append("ReportName: ").append(this.getReportName()).append(",");
        }
        if (this.getTimeUnit() != null) {
            sb.append("TimeUnit: ").append(this.getTimeUnit()).append(",");
        }
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getCompression() != null) {
            sb.append("Compression: ").append(this.getCompression()).append(",");
        }
        if (this.getAdditionalSchemaElements() != null) {
            sb.append("AdditionalSchemaElements: ").append(this.getAdditionalSchemaElements()).append(",");
        }
        if (this.getS3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.getS3Bucket()).append(",");
        }
        if (this.getS3Prefix() != null) {
            sb.append("S3Prefix: ").append(this.getS3Prefix()).append(",");
        }
        if (this.getS3Region() != null) {
            sb.append("S3Region: ").append(this.getS3Region()).append(",");
        }
        if (this.getAdditionalArtifacts() != null) {
            sb.append("AdditionalArtifacts: ").append(this.getAdditionalArtifacts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportDefinition)) {
            return false;
        }
        ReportDefinition other = (ReportDefinition)obj;
        if (other.getReportName() == null ^ this.getReportName() == null) {
            return false;
        }
        if (other.getReportName() != null && !other.getReportName().equals(this.getReportName())) {
            return false;
        }
        if (other.getTimeUnit() == null ^ this.getTimeUnit() == null) {
            return false;
        }
        if (other.getTimeUnit() != null && !other.getTimeUnit().equals(this.getTimeUnit())) {
            return false;
        }
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getCompression() == null ^ this.getCompression() == null) {
            return false;
        }
        if (other.getCompression() != null && !other.getCompression().equals(this.getCompression())) {
            return false;
        }
        if (other.getAdditionalSchemaElements() == null ^ this.getAdditionalSchemaElements() == null) {
            return false;
        }
        if (other.getAdditionalSchemaElements() != null && !other.getAdditionalSchemaElements().equals(this.getAdditionalSchemaElements())) {
            return false;
        }
        if (other.getS3Bucket() == null ^ this.getS3Bucket() == null) {
            return false;
        }
        if (other.getS3Bucket() != null && !other.getS3Bucket().equals(this.getS3Bucket())) {
            return false;
        }
        if (other.getS3Prefix() == null ^ this.getS3Prefix() == null) {
            return false;
        }
        if (other.getS3Prefix() != null && !other.getS3Prefix().equals(this.getS3Prefix())) {
            return false;
        }
        if (other.getS3Region() == null ^ this.getS3Region() == null) {
            return false;
        }
        if (other.getS3Region() != null && !other.getS3Region().equals(this.getS3Region())) {
            return false;
        }
        if (other.getAdditionalArtifacts() == null ^ this.getAdditionalArtifacts() == null) {
            return false;
        }
        return other.getAdditionalArtifacts() == null || other.getAdditionalArtifacts().equals(this.getAdditionalArtifacts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReportName() == null ? 0 : this.getReportName().hashCode());
        hashCode = 31 * hashCode + (this.getTimeUnit() == null ? 0 : this.getTimeUnit().hashCode());
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getCompression() == null ? 0 : this.getCompression().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalSchemaElements() == null ? 0 : this.getAdditionalSchemaElements().hashCode());
        hashCode = 31 * hashCode + (this.getS3Bucket() == null ? 0 : this.getS3Bucket().hashCode());
        hashCode = 31 * hashCode + (this.getS3Prefix() == null ? 0 : this.getS3Prefix().hashCode());
        hashCode = 31 * hashCode + (this.getS3Region() == null ? 0 : this.getS3Region().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalArtifacts() == null ? 0 : this.getAdditionalArtifacts().hashCode());
        return hashCode;
    }

    public ReportDefinition clone() {
        try {
            return (ReportDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReportDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

