/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.datapipeline.model.Field;
import com.amazonaws.services.datapipeline.model.transform.PipelineObjectMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PipelineObject
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String name;
    private SdkInternalList<Field> fields;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public PipelineObject withId(String id) {
        this.setId(id);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PipelineObject withName(String name) {
        this.setName(name);
        return this;
    }

    public List<Field> getFields() {
        if (this.fields == null) {
            this.fields = new SdkInternalList();
        }
        return this.fields;
    }

    public void setFields(Collection<Field> fields) {
        if (fields == null) {
            this.fields = null;
            return;
        }
        this.fields = new SdkInternalList<Field>(fields);
    }

    public PipelineObject withFields(Field ... fields) {
        if (this.fields == null) {
            this.setFields(new SdkInternalList<Field>(fields.length));
        }
        for (Field ele : fields) {
            this.fields.add(ele);
        }
        return this;
    }

    public PipelineObject withFields(Collection<Field> fields) {
        this.setFields(fields);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getFields() != null) {
            sb.append("Fields: ").append(this.getFields());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineObject)) {
            return false;
        }
        PipelineObject other = (PipelineObject)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getFields() == null ^ this.getFields() == null) {
            return false;
        }
        return other.getFields() == null || other.getFields().equals(this.getFields());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getFields() == null ? 0 : this.getFields().hashCode());
        return hashCode;
    }

    public PipelineObject clone() {
        try {
            return (PipelineObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

