/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.identitymanagement.model.CreateUserRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateUserRequestMarshaller
implements Marshaller<Request<CreateUserRequest>, CreateUserRequest> {
    @Override
    public Request<CreateUserRequest> marshall(CreateUserRequest createUserRequest) {
        if (createUserRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateUserRequest> request = new DefaultRequest<CreateUserRequest>(createUserRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "CreateUser");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createUserRequest.getPath() != null) {
            request.addParameter("Path", StringUtils.fromString(createUserRequest.getPath()));
        }
        if (createUserRequest.getUserName() != null) {
            request.addParameter("UserName", StringUtils.fromString(createUserRequest.getUserName()));
        }
        return request;
    }
}

