/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.conditions;

import com.amazonaws.services.stepfunctions.builder.conditions.BinaryCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.BinaryConditionBuilder;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import com.amazonaws.thirdparty.jackson.databind.JsonNode;
import com.amazonaws.thirdparty.jackson.databind.node.DoubleNode;
import com.amazonaws.thirdparty.jackson.databind.node.LongNode;
import com.amazonaws.thirdparty.jackson.databind.node.NumericNode;

public final class NumericLessThanOrEqualCondition
implements BinaryCondition<String> {
    @JsonProperty(value="Variable")
    private final String variable;
    @JsonProperty(value="NumericLessThanEquals")
    private final NumericNode expectedValue;

    private NumericLessThanOrEqualCondition(Builder builder) {
        this.variable = builder.variable;
        this.expectedValue = builder.expectedValue;
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    @Override
    @JsonIgnore
    public String getExpectedValue() {
        return this.expectedValue.asText();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends BinaryConditionBuilder {
        @JsonProperty(value="Variable")
        private String variable;
        @JsonProperty(value="NumericLessThanEquals")
        private NumericNode expectedValue;

        private Builder() {
        }

        @Override
        public Builder variable(String variable) {
            this.variable = variable;
            return this;
        }

        public Builder expectedValue(long expectedValue) {
            this.expectedValue = new LongNode(expectedValue);
            return this;
        }

        public Builder expectedValue(double expectedValue) {
            this.expectedValue = new DoubleNode(expectedValue);
            return this;
        }

        @Override
        BinaryConditionBuilder expectedValue(JsonNode expectedValue) {
            this.expectedValue = (NumericNode)expectedValue;
            return this;
        }

        @Override
        String type() {
            return "NumericLessThanEquals";
        }

        @Override
        public NumericLessThanOrEqualCondition build() {
            return new NumericLessThanOrEqualCondition(this);
        }
    }
}

