/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appstream.model.DirectoryConfig;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DirectoryConfigMarshaller {
    private static final MarshallingInfo<String> DIRECTORYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DirectoryName").build();
    private static final MarshallingInfo<List> ORGANIZATIONALUNITDISTINGUISHEDNAMES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrganizationalUnitDistinguishedNames").build();
    private static final MarshallingInfo<StructuredPojo> SERVICEACCOUNTCREDENTIALS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceAccountCredentials").build();
    private static final MarshallingInfo<Date> CREATEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").build();
    private static final DirectoryConfigMarshaller instance = new DirectoryConfigMarshaller();

    public static DirectoryConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(DirectoryConfig directoryConfig, ProtocolMarshaller protocolMarshaller) {
        if (directoryConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(directoryConfig.getDirectoryName(), DIRECTORYNAME_BINDING);
            protocolMarshaller.marshall(directoryConfig.getOrganizationalUnitDistinguishedNames(), ORGANIZATIONALUNITDISTINGUISHEDNAMES_BINDING);
            protocolMarshaller.marshall(directoryConfig.getServiceAccountCredentials(), SERVICEACCOUNTCREDENTIALS_BINDING);
            protocolMarshaller.marshall(directoryConfig.getCreatedTime(), CREATEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

