/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.OriginCustomHeader;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class OriginCustomHeaderStaxUnmarshaller
implements Unmarshaller<OriginCustomHeader, StaxUnmarshallerContext> {
    private static OriginCustomHeaderStaxUnmarshaller instance;

    @Override
    public OriginCustomHeader unmarshall(StaxUnmarshallerContext context) throws Exception {
        OriginCustomHeader originCustomHeader = new OriginCustomHeader();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return originCustomHeader;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("HeaderName", targetDepth)) {
                    originCustomHeader.setHeaderName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("HeaderValue", targetDepth)) continue;
                originCustomHeader.setHeaderValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return originCustomHeader;
    }

    public static OriginCustomHeaderStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new OriginCustomHeaderStaxUnmarshaller();
        }
        return instance;
    }
}

