/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.common;

import com.amazonaws.services.simpleworkflow.model.PredefinedDuration;
import java.lang.reflect.Method;

public final class FlowHelpers {
    public static String secondsToDuration(Long seconds) {
        if (seconds == null || seconds == -1L) {
            return PredefinedDuration.NONE.toString();
        }
        if (seconds == -2L) {
            return null;
        }
        return Long.toString(seconds);
    }

    public static long durationToSeconds(String duration) {
        if (duration == null || duration.equals(PredefinedDuration.NONE.toString())) {
            return -1L;
        }
        return Long.parseLong(duration);
    }

    public static Object[] validateInput(Method method, Object[] args) {
        Class<?>[] paramterTypes = method.getParameterTypes();
        int numberOfParameters = paramterTypes.length;
        if (args == null || args.length != numberOfParameters) {
            throw new IllegalStateException("Number of parameters does not match args size.");
        }
        int index = 0;
        Class<?>[] classArray = paramterTypes;
        int n = paramterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> paramType = classArray[n2];
            Object argument = args[index];
            if (argument != null && !paramType.isAssignableFrom(argument.getClass())) {
                throw new IllegalStateException("Param type '" + paramType.getName() + "' is not assigable from '" + argument.getClass().getName() + "'.");
            }
            ++index;
            ++n2;
        }
        return args;
    }

    public static String taskPriorityToString(Integer taskPriority) {
        if (taskPriority == null) {
            return null;
        }
        return String.valueOf(taskPriority);
    }

    public static int taskPriorityToInt(String taskPriority) {
        if (taskPriority == null) {
            return 0;
        }
        return Integer.parseInt(taskPriority);
    }
}

