/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesis.model.EncryptionType;
import com.amazonaws.services.kinesis.model.EnhancedMetrics;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.StreamStatus;
import com.amazonaws.services.kinesis.model.transform.StreamDescriptionMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class StreamDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private String streamName;
    private String streamARN;
    private String streamStatus;
    private SdkInternalList<Shard> shards;
    private Boolean hasMoreShards;
    private Integer retentionPeriodHours;
    private Date streamCreationTimestamp;
    private SdkInternalList<EnhancedMetrics> enhancedMonitoring;
    private String encryptionType;
    private String keyId;

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public StreamDescription withStreamName(String streamName) {
        this.setStreamName(streamName);
        return this;
    }

    public void setStreamARN(String streamARN) {
        this.streamARN = streamARN;
    }

    public String getStreamARN() {
        return this.streamARN;
    }

    public StreamDescription withStreamARN(String streamARN) {
        this.setStreamARN(streamARN);
        return this;
    }

    public void setStreamStatus(String streamStatus) {
        this.streamStatus = streamStatus;
    }

    public String getStreamStatus() {
        return this.streamStatus;
    }

    public StreamDescription withStreamStatus(String streamStatus) {
        this.setStreamStatus(streamStatus);
        return this;
    }

    public void setStreamStatus(StreamStatus streamStatus) {
        this.streamStatus = streamStatus.toString();
    }

    public StreamDescription withStreamStatus(StreamStatus streamStatus) {
        this.setStreamStatus(streamStatus);
        return this;
    }

    public List<Shard> getShards() {
        if (this.shards == null) {
            this.shards = new SdkInternalList();
        }
        return this.shards;
    }

    public void setShards(Collection<Shard> shards) {
        if (shards == null) {
            this.shards = null;
            return;
        }
        this.shards = new SdkInternalList<Shard>(shards);
    }

    public StreamDescription withShards(Shard ... shards) {
        if (this.shards == null) {
            this.setShards(new SdkInternalList<Shard>(shards.length));
        }
        for (Shard ele : shards) {
            this.shards.add(ele);
        }
        return this;
    }

    public StreamDescription withShards(Collection<Shard> shards) {
        this.setShards(shards);
        return this;
    }

    public void setHasMoreShards(Boolean hasMoreShards) {
        this.hasMoreShards = hasMoreShards;
    }

    public Boolean getHasMoreShards() {
        return this.hasMoreShards;
    }

    public StreamDescription withHasMoreShards(Boolean hasMoreShards) {
        this.setHasMoreShards(hasMoreShards);
        return this;
    }

    public Boolean isHasMoreShards() {
        return this.hasMoreShards;
    }

    public void setRetentionPeriodHours(Integer retentionPeriodHours) {
        this.retentionPeriodHours = retentionPeriodHours;
    }

    public Integer getRetentionPeriodHours() {
        return this.retentionPeriodHours;
    }

    public StreamDescription withRetentionPeriodHours(Integer retentionPeriodHours) {
        this.setRetentionPeriodHours(retentionPeriodHours);
        return this;
    }

    public void setStreamCreationTimestamp(Date streamCreationTimestamp) {
        this.streamCreationTimestamp = streamCreationTimestamp;
    }

    public Date getStreamCreationTimestamp() {
        return this.streamCreationTimestamp;
    }

    public StreamDescription withStreamCreationTimestamp(Date streamCreationTimestamp) {
        this.setStreamCreationTimestamp(streamCreationTimestamp);
        return this;
    }

    public List<EnhancedMetrics> getEnhancedMonitoring() {
        if (this.enhancedMonitoring == null) {
            this.enhancedMonitoring = new SdkInternalList();
        }
        return this.enhancedMonitoring;
    }

    public void setEnhancedMonitoring(Collection<EnhancedMetrics> enhancedMonitoring) {
        if (enhancedMonitoring == null) {
            this.enhancedMonitoring = null;
            return;
        }
        this.enhancedMonitoring = new SdkInternalList<EnhancedMetrics>(enhancedMonitoring);
    }

    public StreamDescription withEnhancedMonitoring(EnhancedMetrics ... enhancedMonitoring) {
        if (this.enhancedMonitoring == null) {
            this.setEnhancedMonitoring(new SdkInternalList<EnhancedMetrics>(enhancedMonitoring.length));
        }
        for (EnhancedMetrics ele : enhancedMonitoring) {
            this.enhancedMonitoring.add(ele);
        }
        return this;
    }

    public StreamDescription withEnhancedMonitoring(Collection<EnhancedMetrics> enhancedMonitoring) {
        this.setEnhancedMonitoring(enhancedMonitoring);
        return this;
    }

    public void setEncryptionType(String encryptionType) {
        this.encryptionType = encryptionType;
    }

    public String getEncryptionType() {
        return this.encryptionType;
    }

    public StreamDescription withEncryptionType(String encryptionType) {
        this.setEncryptionType(encryptionType);
        return this;
    }

    public void setEncryptionType(EncryptionType encryptionType) {
        this.encryptionType = encryptionType.toString();
    }

    public StreamDescription withEncryptionType(EncryptionType encryptionType) {
        this.setEncryptionType(encryptionType);
        return this;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public StreamDescription withKeyId(String keyId) {
        this.setKeyId(keyId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStreamName() != null) {
            sb.append("StreamName: ").append(this.getStreamName()).append(",");
        }
        if (this.getStreamARN() != null) {
            sb.append("StreamARN: ").append(this.getStreamARN()).append(",");
        }
        if (this.getStreamStatus() != null) {
            sb.append("StreamStatus: ").append(this.getStreamStatus()).append(",");
        }
        if (this.getShards() != null) {
            sb.append("Shards: ").append(this.getShards()).append(",");
        }
        if (this.getHasMoreShards() != null) {
            sb.append("HasMoreShards: ").append(this.getHasMoreShards()).append(",");
        }
        if (this.getRetentionPeriodHours() != null) {
            sb.append("RetentionPeriodHours: ").append(this.getRetentionPeriodHours()).append(",");
        }
        if (this.getStreamCreationTimestamp() != null) {
            sb.append("StreamCreationTimestamp: ").append(this.getStreamCreationTimestamp()).append(",");
        }
        if (this.getEnhancedMonitoring() != null) {
            sb.append("EnhancedMonitoring: ").append(this.getEnhancedMonitoring()).append(",");
        }
        if (this.getEncryptionType() != null) {
            sb.append("EncryptionType: ").append(this.getEncryptionType()).append(",");
        }
        if (this.getKeyId() != null) {
            sb.append("KeyId: ").append(this.getKeyId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamDescription)) {
            return false;
        }
        StreamDescription other = (StreamDescription)obj;
        if (other.getStreamName() == null ^ this.getStreamName() == null) {
            return false;
        }
        if (other.getStreamName() != null && !other.getStreamName().equals(this.getStreamName())) {
            return false;
        }
        if (other.getStreamARN() == null ^ this.getStreamARN() == null) {
            return false;
        }
        if (other.getStreamARN() != null && !other.getStreamARN().equals(this.getStreamARN())) {
            return false;
        }
        if (other.getStreamStatus() == null ^ this.getStreamStatus() == null) {
            return false;
        }
        if (other.getStreamStatus() != null && !other.getStreamStatus().equals(this.getStreamStatus())) {
            return false;
        }
        if (other.getShards() == null ^ this.getShards() == null) {
            return false;
        }
        if (other.getShards() != null && !other.getShards().equals(this.getShards())) {
            return false;
        }
        if (other.getHasMoreShards() == null ^ this.getHasMoreShards() == null) {
            return false;
        }
        if (other.getHasMoreShards() != null && !other.getHasMoreShards().equals(this.getHasMoreShards())) {
            return false;
        }
        if (other.getRetentionPeriodHours() == null ^ this.getRetentionPeriodHours() == null) {
            return false;
        }
        if (other.getRetentionPeriodHours() != null && !other.getRetentionPeriodHours().equals(this.getRetentionPeriodHours())) {
            return false;
        }
        if (other.getStreamCreationTimestamp() == null ^ this.getStreamCreationTimestamp() == null) {
            return false;
        }
        if (other.getStreamCreationTimestamp() != null && !other.getStreamCreationTimestamp().equals(this.getStreamCreationTimestamp())) {
            return false;
        }
        if (other.getEnhancedMonitoring() == null ^ this.getEnhancedMonitoring() == null) {
            return false;
        }
        if (other.getEnhancedMonitoring() != null && !other.getEnhancedMonitoring().equals(this.getEnhancedMonitoring())) {
            return false;
        }
        if (other.getEncryptionType() == null ^ this.getEncryptionType() == null) {
            return false;
        }
        if (other.getEncryptionType() != null && !other.getEncryptionType().equals(this.getEncryptionType())) {
            return false;
        }
        if (other.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        return other.getKeyId() == null || other.getKeyId().equals(this.getKeyId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStreamName() == null ? 0 : this.getStreamName().hashCode());
        hashCode = 31 * hashCode + (this.getStreamARN() == null ? 0 : this.getStreamARN().hashCode());
        hashCode = 31 * hashCode + (this.getStreamStatus() == null ? 0 : this.getStreamStatus().hashCode());
        hashCode = 31 * hashCode + (this.getShards() == null ? 0 : this.getShards().hashCode());
        hashCode = 31 * hashCode + (this.getHasMoreShards() == null ? 0 : this.getHasMoreShards().hashCode());
        hashCode = 31 * hashCode + (this.getRetentionPeriodHours() == null ? 0 : this.getRetentionPeriodHours().hashCode());
        hashCode = 31 * hashCode + (this.getStreamCreationTimestamp() == null ? 0 : this.getStreamCreationTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getEnhancedMonitoring() == null ? 0 : this.getEnhancedMonitoring().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionType() == null ? 0 : this.getEncryptionType().hashCode());
        hashCode = 31 * hashCode + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        return hashCode;
    }

    public StreamDescription clone() {
        try {
            return (StreamDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

