/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mturk.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mturk.model.EventType;
import com.amazonaws.services.mturk.model.NotificationTransport;
import com.amazonaws.services.mturk.model.transform.NotificationSpecificationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NotificationSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private String destination;
    private String transport;
    private String version;
    private List<String> eventTypes;

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public NotificationSpecification withDestination(String destination) {
        this.setDestination(destination);
        return this;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public String getTransport() {
        return this.transport;
    }

    public NotificationSpecification withTransport(String transport) {
        this.setTransport(transport);
        return this;
    }

    public void setTransport(NotificationTransport transport) {
        this.transport = transport.toString();
    }

    public NotificationSpecification withTransport(NotificationTransport transport) {
        this.setTransport(transport);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public NotificationSpecification withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public List<String> getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(Collection<String> eventTypes) {
        if (eventTypes == null) {
            this.eventTypes = null;
            return;
        }
        this.eventTypes = new ArrayList<String>(eventTypes);
    }

    public NotificationSpecification withEventTypes(String ... eventTypes) {
        if (this.eventTypes == null) {
            this.setEventTypes(new ArrayList<String>(eventTypes.length));
        }
        for (String ele : eventTypes) {
            this.eventTypes.add(ele);
        }
        return this;
    }

    public NotificationSpecification withEventTypes(Collection<String> eventTypes) {
        this.setEventTypes(eventTypes);
        return this;
    }

    public NotificationSpecification withEventTypes(EventType ... eventTypes) {
        ArrayList<String> eventTypesCopy = new ArrayList<String>(eventTypes.length);
        for (EventType value : eventTypes) {
            eventTypesCopy.add(value.toString());
        }
        if (this.getEventTypes() == null) {
            this.setEventTypes(eventTypesCopy);
        } else {
            this.getEventTypes().addAll(eventTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDestination() != null) {
            sb.append("Destination: ").append(this.getDestination()).append(",");
        }
        if (this.getTransport() != null) {
            sb.append("Transport: ").append(this.getTransport()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getEventTypes() != null) {
            sb.append("EventTypes: ").append(this.getEventTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationSpecification)) {
            return false;
        }
        NotificationSpecification other = (NotificationSpecification)obj;
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getTransport() == null ^ this.getTransport() == null) {
            return false;
        }
        if (other.getTransport() != null && !other.getTransport().equals(this.getTransport())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getEventTypes() == null ^ this.getEventTypes() == null) {
            return false;
        }
        return other.getEventTypes() == null || other.getEventTypes().equals(this.getEventTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getTransport() == null ? 0 : this.getTransport().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getEventTypes() == null ? 0 : this.getEventTypes().hashCode());
        return hashCode;
    }

    public NotificationSpecification clone() {
        try {
            return (NotificationSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

