/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cognitoidp.model.IdentityProviderTypeType;
import com.amazonaws.services.cognitoidp.model.transform.IdentityProviderTypeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IdentityProviderType
implements Serializable,
Cloneable,
StructuredPojo {
    private String userPoolId;
    private String providerName;
    private String providerType;
    private Map<String, String> providerDetails;
    private Map<String, String> attributeMapping;
    private List<String> idpIdentifiers;
    private Date lastModifiedDate;
    private Date creationDate;

    public void setUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
    }

    public String getUserPoolId() {
        return this.userPoolId;
    }

    public IdentityProviderType withUserPoolId(String userPoolId) {
        this.setUserPoolId(userPoolId);
        return this;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public IdentityProviderType withProviderName(String providerName) {
        this.setProviderName(providerName);
        return this;
    }

    public void setProviderType(String providerType) {
        this.providerType = providerType;
    }

    public String getProviderType() {
        return this.providerType;
    }

    public IdentityProviderType withProviderType(String providerType) {
        this.setProviderType(providerType);
        return this;
    }

    public void setProviderType(IdentityProviderTypeType providerType) {
        this.providerType = providerType.toString();
    }

    public IdentityProviderType withProviderType(IdentityProviderTypeType providerType) {
        this.setProviderType(providerType);
        return this;
    }

    public Map<String, String> getProviderDetails() {
        return this.providerDetails;
    }

    public void setProviderDetails(Map<String, String> providerDetails) {
        this.providerDetails = providerDetails;
    }

    public IdentityProviderType withProviderDetails(Map<String, String> providerDetails) {
        this.setProviderDetails(providerDetails);
        return this;
    }

    public IdentityProviderType addProviderDetailsEntry(String key, String value) {
        if (null == this.providerDetails) {
            this.providerDetails = new HashMap<String, String>();
        }
        if (this.providerDetails.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.providerDetails.put(key, value);
        return this;
    }

    public IdentityProviderType clearProviderDetailsEntries() {
        this.providerDetails = null;
        return this;
    }

    public Map<String, String> getAttributeMapping() {
        return this.attributeMapping;
    }

    public void setAttributeMapping(Map<String, String> attributeMapping) {
        this.attributeMapping = attributeMapping;
    }

    public IdentityProviderType withAttributeMapping(Map<String, String> attributeMapping) {
        this.setAttributeMapping(attributeMapping);
        return this;
    }

    public IdentityProviderType addAttributeMappingEntry(String key, String value) {
        if (null == this.attributeMapping) {
            this.attributeMapping = new HashMap<String, String>();
        }
        if (this.attributeMapping.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributeMapping.put(key, value);
        return this;
    }

    public IdentityProviderType clearAttributeMappingEntries() {
        this.attributeMapping = null;
        return this;
    }

    public List<String> getIdpIdentifiers() {
        return this.idpIdentifiers;
    }

    public void setIdpIdentifiers(Collection<String> idpIdentifiers) {
        if (idpIdentifiers == null) {
            this.idpIdentifiers = null;
            return;
        }
        this.idpIdentifiers = new ArrayList<String>(idpIdentifiers);
    }

    public IdentityProviderType withIdpIdentifiers(String ... idpIdentifiers) {
        if (this.idpIdentifiers == null) {
            this.setIdpIdentifiers(new ArrayList<String>(idpIdentifiers.length));
        }
        for (String ele : idpIdentifiers) {
            this.idpIdentifiers.add(ele);
        }
        return this;
    }

    public IdentityProviderType withIdpIdentifiers(Collection<String> idpIdentifiers) {
        this.setIdpIdentifiers(idpIdentifiers);
        return this;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public IdentityProviderType withLastModifiedDate(Date lastModifiedDate) {
        this.setLastModifiedDate(lastModifiedDate);
        return this;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public IdentityProviderType withCreationDate(Date creationDate) {
        this.setCreationDate(creationDate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserPoolId() != null) {
            sb.append("UserPoolId: ").append(this.getUserPoolId()).append(",");
        }
        if (this.getProviderName() != null) {
            sb.append("ProviderName: ").append(this.getProviderName()).append(",");
        }
        if (this.getProviderType() != null) {
            sb.append("ProviderType: ").append(this.getProviderType()).append(",");
        }
        if (this.getProviderDetails() != null) {
            sb.append("ProviderDetails: ").append(this.getProviderDetails()).append(",");
        }
        if (this.getAttributeMapping() != null) {
            sb.append("AttributeMapping: ").append(this.getAttributeMapping()).append(",");
        }
        if (this.getIdpIdentifiers() != null) {
            sb.append("IdpIdentifiers: ").append(this.getIdpIdentifiers()).append(",");
        }
        if (this.getLastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.getLastModifiedDate()).append(",");
        }
        if (this.getCreationDate() != null) {
            sb.append("CreationDate: ").append(this.getCreationDate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProviderType)) {
            return false;
        }
        IdentityProviderType other = (IdentityProviderType)obj;
        if (other.getUserPoolId() == null ^ this.getUserPoolId() == null) {
            return false;
        }
        if (other.getUserPoolId() != null && !other.getUserPoolId().equals(this.getUserPoolId())) {
            return false;
        }
        if (other.getProviderName() == null ^ this.getProviderName() == null) {
            return false;
        }
        if (other.getProviderName() != null && !other.getProviderName().equals(this.getProviderName())) {
            return false;
        }
        if (other.getProviderType() == null ^ this.getProviderType() == null) {
            return false;
        }
        if (other.getProviderType() != null && !other.getProviderType().equals(this.getProviderType())) {
            return false;
        }
        if (other.getProviderDetails() == null ^ this.getProviderDetails() == null) {
            return false;
        }
        if (other.getProviderDetails() != null && !other.getProviderDetails().equals(this.getProviderDetails())) {
            return false;
        }
        if (other.getAttributeMapping() == null ^ this.getAttributeMapping() == null) {
            return false;
        }
        if (other.getAttributeMapping() != null && !other.getAttributeMapping().equals(this.getAttributeMapping())) {
            return false;
        }
        if (other.getIdpIdentifiers() == null ^ this.getIdpIdentifiers() == null) {
            return false;
        }
        if (other.getIdpIdentifiers() != null && !other.getIdpIdentifiers().equals(this.getIdpIdentifiers())) {
            return false;
        }
        if (other.getLastModifiedDate() == null ^ this.getLastModifiedDate() == null) {
            return false;
        }
        if (other.getLastModifiedDate() != null && !other.getLastModifiedDate().equals(this.getLastModifiedDate())) {
            return false;
        }
        if (other.getCreationDate() == null ^ this.getCreationDate() == null) {
            return false;
        }
        return other.getCreationDate() == null || other.getCreationDate().equals(this.getCreationDate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserPoolId() == null ? 0 : this.getUserPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getProviderName() == null ? 0 : this.getProviderName().hashCode());
        hashCode = 31 * hashCode + (this.getProviderType() == null ? 0 : this.getProviderType().hashCode());
        hashCode = 31 * hashCode + (this.getProviderDetails() == null ? 0 : this.getProviderDetails().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeMapping() == null ? 0 : this.getAttributeMapping().hashCode());
        hashCode = 31 * hashCode + (this.getIdpIdentifiers() == null ? 0 : this.getIdpIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedDate() == null ? 0 : this.getLastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.getCreationDate() == null ? 0 : this.getCreationDate().hashCode());
        return hashCode;
    }

    public IdentityProviderType clone() {
        try {
            return (IdentityProviderType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IdentityProviderTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

