/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.test;

import com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTask;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCancellationHandler;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCompletionHandle;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import java.util.PriorityQueue;

public class TestWorkflowClock
implements WorkflowClock {
    private static final int SECOND = 1000;
    private long clockTime = 0L;
    private PriorityQueue<TimerInfo<?>> timers = new PriorityQueue();

    @Override
    public long currentTimeMillis() {
        return this.clockTime;
    }

    public void setCurrentTimeMillis(long timeMillis) {
        this.clockTime = timeMillis;
    }

    @Override
    public boolean isReplaying() {
        return false;
    }

    @Override
    public Promise<Void> createTimer(long delaySeconds) {
        return this.createTimer(delaySeconds, null);
    }

    @Override
    public <T> Promise<T> createTimer(long delaySeconds, T context) {
        if (delaySeconds < 0L) {
            throw new IllegalArgumentException("negative delaySeconds");
        }
        if (delaySeconds == 0L) {
            return Promise.asPromise(context);
        }
        long fireTime = this.clockTime + delaySeconds * 1000L;
        final TimerInfo<T> timer = new TimerInfo<T>(fireTime, context);
        String timerName = "delay=" + delaySeconds;
        timer.setResultDescription("createTimer " + timerName);
        this.timers.add(timer);
        new ExternalTask(new Promise[0]){

            @Override
            protected ExternalTaskCancellationHandler doExecute(ExternalTaskCompletionHandle handle) throws Throwable {
                timer.setCompletionHandle(handle);
                return new ExternalTaskCancellationHandler(){

                    @Override
                    public void handleCancellation(Throwable e) {
                        TestWorkflowClock.this.timers.remove(timer);
                        timer.cancel();
                    }
                };
            }
        }.setName(timerName);
        return timer.getResult();
    }

    public Long fireTimers() {
        TimerInfo<?> timer;
        while ((timer = this.timers.peek()) != null) {
            long timerTime = timer.getFireTime();
            if (timerTime > this.clockTime) {
                return timerTime - this.clockTime;
            }
            this.timers.poll();
            timer.fire();
        }
        return null;
    }

    public void advanceSeconds(long seconds) {
        this.advanceMilliseconds(seconds * 1000L);
    }

    public void advanceMilliseconds(long milliseconds) {
        long timerTime;
        TimerInfo<?> timer;
        this.clockTime += milliseconds;
        while ((timer = this.timers.peek()) != null && (timerTime = timer.getFireTime()) <= this.clockTime) {
            timer.fire();
            this.timers.poll();
        }
    }

    private static class TimerInfo<T>
    implements Comparable<TimerInfo<T>> {
        final Long fireTime;
        final Settable<T> timerResult = new Settable();
        final T context;
        private Settable<ExternalTaskCompletionHandle> handle = new Settable();

        public TimerInfo(long fireTime, T context) {
            this.fireTime = fireTime;
            this.context = context;
        }

        public void fire() {
            this.timerResult.set(this.context);
            if (this.handle.isReady()) {
                this.handle.get().complete();
            } else {
                new Task(new Promise[]{this.handle}){

                    @Override
                    protected void doExecute() throws Throwable {
                        ((ExternalTaskCompletionHandle)TimerInfo.this.handle.get()).complete();
                    }
                };
            }
        }

        public Promise<T> getResult() {
            return this.timerResult;
        }

        @Override
        public int compareTo(TimerInfo<T> o) {
            return this.fireTime.compareTo(o.fireTime);
        }

        public void cancel() {
            this.handle.get().complete();
        }

        public long getFireTime() {
            return this.fireTime;
        }

        public void setCompletionHandle(ExternalTaskCompletionHandle handle) {
            this.handle.set(handle);
        }

        public void setResultDescription(String description) {
            this.timerResult.setDescription(description);
        }
    }
}

