/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kinesis.model.MetricsName;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class EnableEnhancedMonitoringRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String streamName;
    private SdkInternalList<String> shardLevelMetrics;

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public EnableEnhancedMonitoringRequest withStreamName(String streamName) {
        this.setStreamName(streamName);
        return this;
    }

    public List<String> getShardLevelMetrics() {
        if (this.shardLevelMetrics == null) {
            this.shardLevelMetrics = new SdkInternalList();
        }
        return this.shardLevelMetrics;
    }

    public void setShardLevelMetrics(Collection<String> shardLevelMetrics) {
        if (shardLevelMetrics == null) {
            this.shardLevelMetrics = null;
            return;
        }
        this.shardLevelMetrics = new SdkInternalList<String>(shardLevelMetrics);
    }

    public EnableEnhancedMonitoringRequest withShardLevelMetrics(String ... shardLevelMetrics) {
        if (this.shardLevelMetrics == null) {
            this.setShardLevelMetrics(new SdkInternalList<String>(shardLevelMetrics.length));
        }
        for (String ele : shardLevelMetrics) {
            this.shardLevelMetrics.add(ele);
        }
        return this;
    }

    public EnableEnhancedMonitoringRequest withShardLevelMetrics(Collection<String> shardLevelMetrics) {
        this.setShardLevelMetrics(shardLevelMetrics);
        return this;
    }

    public EnableEnhancedMonitoringRequest withShardLevelMetrics(MetricsName ... shardLevelMetrics) {
        SdkInternalList<String> shardLevelMetricsCopy = new SdkInternalList<String>(shardLevelMetrics.length);
        for (MetricsName value : shardLevelMetrics) {
            shardLevelMetricsCopy.add(value.toString());
        }
        if (this.getShardLevelMetrics() == null) {
            this.setShardLevelMetrics(shardLevelMetricsCopy);
        } else {
            this.getShardLevelMetrics().addAll(shardLevelMetricsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStreamName() != null) {
            sb.append("StreamName: ").append(this.getStreamName()).append(",");
        }
        if (this.getShardLevelMetrics() != null) {
            sb.append("ShardLevelMetrics: ").append(this.getShardLevelMetrics());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableEnhancedMonitoringRequest)) {
            return false;
        }
        EnableEnhancedMonitoringRequest other = (EnableEnhancedMonitoringRequest)obj;
        if (other.getStreamName() == null ^ this.getStreamName() == null) {
            return false;
        }
        if (other.getStreamName() != null && !other.getStreamName().equals(this.getStreamName())) {
            return false;
        }
        if (other.getShardLevelMetrics() == null ^ this.getShardLevelMetrics() == null) {
            return false;
        }
        return other.getShardLevelMetrics() == null || other.getShardLevelMetrics().equals(this.getShardLevelMetrics());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStreamName() == null ? 0 : this.getStreamName().hashCode());
        hashCode = 31 * hashCode + (this.getShardLevelMetrics() == null ? 0 : this.getShardLevelMetrics().hashCode());
        return hashCode;
    }

    @Override
    public EnableEnhancedMonitoringRequest clone() {
        return (EnableEnhancedMonitoringRequest)super.clone();
    }
}

