/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.Action;

@SdkInternalApi
public class ActionMarshaller {
    private static final MarshallingInfo<StructuredPojo> DYNAMODB_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dynamoDB").build();
    private static final MarshallingInfo<StructuredPojo> DYNAMODBV2_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dynamoDBv2").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambda").build();
    private static final MarshallingInfo<StructuredPojo> SNS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sns").build();
    private static final MarshallingInfo<StructuredPojo> SQS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sqs").build();
    private static final MarshallingInfo<StructuredPojo> KINESIS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kinesis").build();
    private static final MarshallingInfo<StructuredPojo> REPUBLISH_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("republish").build();
    private static final MarshallingInfo<StructuredPojo> S3_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3").build();
    private static final MarshallingInfo<StructuredPojo> FIREHOSE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firehose").build();
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHMETRIC_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cloudwatchMetric").build();
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHALARM_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cloudwatchAlarm").build();
    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCH_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("elasticsearch").build();
    private static final ActionMarshaller instance = new ActionMarshaller();

    public static ActionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Action action, ProtocolMarshaller protocolMarshaller) {
        if (action == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(action.getDynamoDB(), DYNAMODB_BINDING);
            protocolMarshaller.marshall(action.getDynamoDBv2(), DYNAMODBV2_BINDING);
            protocolMarshaller.marshall(action.getLambda(), LAMBDA_BINDING);
            protocolMarshaller.marshall(action.getSns(), SNS_BINDING);
            protocolMarshaller.marshall(action.getSqs(), SQS_BINDING);
            protocolMarshaller.marshall(action.getKinesis(), KINESIS_BINDING);
            protocolMarshaller.marshall(action.getRepublish(), REPUBLISH_BINDING);
            protocolMarshaller.marshall(action.getS3(), S3_BINDING);
            protocolMarshaller.marshall(action.getFirehose(), FIREHOSE_BINDING);
            protocolMarshaller.marshall(action.getCloudwatchMetric(), CLOUDWATCHMETRIC_BINDING);
            protocolMarshaller.marshall(action.getCloudwatchAlarm(), CLOUDWATCHALARM_BINDING);
            protocolMarshaller.marshall(action.getElasticsearch(), ELASTICSEARCH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

