/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.services.cloudtrail.model.Resource;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class ResourceJsonUnmarshaller
implements Unmarshaller<Resource, JsonUnmarshallerContext> {
    private static ResourceJsonUnmarshaller instance;

    @Override
    public Resource unmarshall(JsonUnmarshallerContext context) throws Exception {
        Resource resource = new Resource();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ResourceType", targetDepth)) {
                    context.nextToken();
                    resource.setResourceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ResourceName", targetDepth)) {
                    context.nextToken();
                    resource.setResourceName(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return resource;
    }

    public static ResourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceJsonUnmarshaller();
        }
        return instance;
    }
}

