/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codebuild.model.BuildArtifacts;
import com.amazonaws.services.codebuild.model.BuildPhase;
import com.amazonaws.services.codebuild.model.LogsLocation;
import com.amazonaws.services.codebuild.model.ProjectEnvironment;
import com.amazonaws.services.codebuild.model.ProjectSource;
import com.amazonaws.services.codebuild.model.StatusType;
import com.amazonaws.services.codebuild.model.transform.BuildMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Build
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String arn;
    private Date startTime;
    private Date endTime;
    private String currentPhase;
    private String buildStatus;
    private String sourceVersion;
    private String projectName;
    private List<BuildPhase> phases;
    private ProjectSource source;
    private BuildArtifacts artifacts;
    private ProjectEnvironment environment;
    private LogsLocation logs;
    private Integer timeoutInMinutes;
    private Boolean buildComplete;
    private String initiator;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Build withId(String id) {
        this.setId(id);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Build withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Build withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Build withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setCurrentPhase(String currentPhase) {
        this.currentPhase = currentPhase;
    }

    public String getCurrentPhase() {
        return this.currentPhase;
    }

    public Build withCurrentPhase(String currentPhase) {
        this.setCurrentPhase(currentPhase);
        return this;
    }

    public void setBuildStatus(String buildStatus) {
        this.buildStatus = buildStatus;
    }

    public String getBuildStatus() {
        return this.buildStatus;
    }

    public Build withBuildStatus(String buildStatus) {
        this.setBuildStatus(buildStatus);
        return this;
    }

    public void setBuildStatus(StatusType buildStatus) {
        this.buildStatus = buildStatus.toString();
    }

    public Build withBuildStatus(StatusType buildStatus) {
        this.setBuildStatus(buildStatus);
        return this;
    }

    public void setSourceVersion(String sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public Build withSourceVersion(String sourceVersion) {
        this.setSourceVersion(sourceVersion);
        return this;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Build withProjectName(String projectName) {
        this.setProjectName(projectName);
        return this;
    }

    public List<BuildPhase> getPhases() {
        return this.phases;
    }

    public void setPhases(Collection<BuildPhase> phases) {
        if (phases == null) {
            this.phases = null;
            return;
        }
        this.phases = new ArrayList<BuildPhase>(phases);
    }

    public Build withPhases(BuildPhase ... phases) {
        if (this.phases == null) {
            this.setPhases(new ArrayList<BuildPhase>(phases.length));
        }
        for (BuildPhase ele : phases) {
            this.phases.add(ele);
        }
        return this;
    }

    public Build withPhases(Collection<BuildPhase> phases) {
        this.setPhases(phases);
        return this;
    }

    public void setSource(ProjectSource source) {
        this.source = source;
    }

    public ProjectSource getSource() {
        return this.source;
    }

    public Build withSource(ProjectSource source) {
        this.setSource(source);
        return this;
    }

    public void setArtifacts(BuildArtifacts artifacts) {
        this.artifacts = artifacts;
    }

    public BuildArtifacts getArtifacts() {
        return this.artifacts;
    }

    public Build withArtifacts(BuildArtifacts artifacts) {
        this.setArtifacts(artifacts);
        return this;
    }

    public void setEnvironment(ProjectEnvironment environment) {
        this.environment = environment;
    }

    public ProjectEnvironment getEnvironment() {
        return this.environment;
    }

    public Build withEnvironment(ProjectEnvironment environment) {
        this.setEnvironment(environment);
        return this;
    }

    public void setLogs(LogsLocation logs) {
        this.logs = logs;
    }

    public LogsLocation getLogs() {
        return this.logs;
    }

    public Build withLogs(LogsLocation logs) {
        this.setLogs(logs);
        return this;
    }

    public void setTimeoutInMinutes(Integer timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
    }

    public Integer getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public Build withTimeoutInMinutes(Integer timeoutInMinutes) {
        this.setTimeoutInMinutes(timeoutInMinutes);
        return this;
    }

    public void setBuildComplete(Boolean buildComplete) {
        this.buildComplete = buildComplete;
    }

    public Boolean getBuildComplete() {
        return this.buildComplete;
    }

    public Build withBuildComplete(Boolean buildComplete) {
        this.setBuildComplete(buildComplete);
        return this;
    }

    public Boolean isBuildComplete() {
        return this.buildComplete;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public Build withInitiator(String initiator) {
        this.setInitiator(initiator);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getCurrentPhase() != null) {
            sb.append("CurrentPhase: ").append(this.getCurrentPhase()).append(",");
        }
        if (this.getBuildStatus() != null) {
            sb.append("BuildStatus: ").append(this.getBuildStatus()).append(",");
        }
        if (this.getSourceVersion() != null) {
            sb.append("SourceVersion: ").append(this.getSourceVersion()).append(",");
        }
        if (this.getProjectName() != null) {
            sb.append("ProjectName: ").append(this.getProjectName()).append(",");
        }
        if (this.getPhases() != null) {
            sb.append("Phases: ").append(this.getPhases()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getArtifacts() != null) {
            sb.append("Artifacts: ").append(this.getArtifacts()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment()).append(",");
        }
        if (this.getLogs() != null) {
            sb.append("Logs: ").append(this.getLogs()).append(",");
        }
        if (this.getTimeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: ").append(this.getTimeoutInMinutes()).append(",");
        }
        if (this.getBuildComplete() != null) {
            sb.append("BuildComplete: ").append(this.getBuildComplete()).append(",");
        }
        if (this.getInitiator() != null) {
            sb.append("Initiator: ").append(this.getInitiator());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Build)) {
            return false;
        }
        Build other = (Build)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getCurrentPhase() == null ^ this.getCurrentPhase() == null) {
            return false;
        }
        if (other.getCurrentPhase() != null && !other.getCurrentPhase().equals(this.getCurrentPhase())) {
            return false;
        }
        if (other.getBuildStatus() == null ^ this.getBuildStatus() == null) {
            return false;
        }
        if (other.getBuildStatus() != null && !other.getBuildStatus().equals(this.getBuildStatus())) {
            return false;
        }
        if (other.getSourceVersion() == null ^ this.getSourceVersion() == null) {
            return false;
        }
        if (other.getSourceVersion() != null && !other.getSourceVersion().equals(this.getSourceVersion())) {
            return false;
        }
        if (other.getProjectName() == null ^ this.getProjectName() == null) {
            return false;
        }
        if (other.getProjectName() != null && !other.getProjectName().equals(this.getProjectName())) {
            return false;
        }
        if (other.getPhases() == null ^ this.getPhases() == null) {
            return false;
        }
        if (other.getPhases() != null && !other.getPhases().equals(this.getPhases())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getArtifacts() == null ^ this.getArtifacts() == null) {
            return false;
        }
        if (other.getArtifacts() != null && !other.getArtifacts().equals(this.getArtifacts())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getLogs() == null ^ this.getLogs() == null) {
            return false;
        }
        if (other.getLogs() != null && !other.getLogs().equals(this.getLogs())) {
            return false;
        }
        if (other.getTimeoutInMinutes() == null ^ this.getTimeoutInMinutes() == null) {
            return false;
        }
        if (other.getTimeoutInMinutes() != null && !other.getTimeoutInMinutes().equals(this.getTimeoutInMinutes())) {
            return false;
        }
        if (other.getBuildComplete() == null ^ this.getBuildComplete() == null) {
            return false;
        }
        if (other.getBuildComplete() != null && !other.getBuildComplete().equals(this.getBuildComplete())) {
            return false;
        }
        if (other.getInitiator() == null ^ this.getInitiator() == null) {
            return false;
        }
        return other.getInitiator() == null || other.getInitiator().equals(this.getInitiator());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentPhase() == null ? 0 : this.getCurrentPhase().hashCode());
        hashCode = 31 * hashCode + (this.getBuildStatus() == null ? 0 : this.getBuildStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSourceVersion() == null ? 0 : this.getSourceVersion().hashCode());
        hashCode = 31 * hashCode + (this.getProjectName() == null ? 0 : this.getProjectName().hashCode());
        hashCode = 31 * hashCode + (this.getPhases() == null ? 0 : this.getPhases().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getArtifacts() == null ? 0 : this.getArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getLogs() == null ? 0 : this.getLogs().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutInMinutes() == null ? 0 : this.getTimeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getBuildComplete() == null ? 0 : this.getBuildComplete().hashCode());
        hashCode = 31 * hashCode + (this.getInitiator() == null ? 0 : this.getInitiator().hashCode());
        return hashCode;
    }

    public Build clone() {
        try {
            return (Build)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuildMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

