/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.thirdparty.apache.http.impl.conn;

import com.amazonaws.thirdparty.apache.http.HttpResponse;
import com.amazonaws.thirdparty.apache.http.HttpResponseFactory;
import com.amazonaws.thirdparty.apache.http.annotation.Immutable;
import com.amazonaws.thirdparty.apache.http.config.MessageConstraints;
import com.amazonaws.thirdparty.apache.http.impl.DefaultHttpResponseFactory;
import com.amazonaws.thirdparty.apache.http.impl.conn.DefaultHttpResponseParser;
import com.amazonaws.thirdparty.apache.http.io.HttpMessageParser;
import com.amazonaws.thirdparty.apache.http.io.HttpMessageParserFactory;
import com.amazonaws.thirdparty.apache.http.io.SessionInputBuffer;
import com.amazonaws.thirdparty.apache.http.message.BasicLineParser;
import com.amazonaws.thirdparty.apache.http.message.LineParser;

@Immutable
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

