/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.states;

import com.amazonaws.services.stepfunctions.builder.internal.Buildable;
import com.amazonaws.services.stepfunctions.builder.states.Choice;
import com.amazonaws.services.stepfunctions.builder.states.State;
import com.amazonaws.services.stepfunctions.builder.states.StateVisitor;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

public final class ChoiceState
implements State {
    @JsonProperty(value="Comment")
    private final String comment;
    @JsonProperty(value="Default")
    private final String defaultStateName;
    @JsonProperty(value="Choices")
    private final List<Choice> choices;
    @JsonProperty(value="InputPath")
    private final String inputPath;
    @JsonProperty(value="OutputPath")
    private final String outputPath;

    private ChoiceState(Builder builder) {
        this.comment = builder.comment;
        this.defaultStateName = builder.defaultStateName;
        this.choices = Buildable.Utils.build(builder.choices);
        this.inputPath = builder.inputPath;
        this.outputPath = builder.outputPath;
    }

    @Override
    public String getType() {
        return "Choice";
    }

    public String getComment() {
        return this.comment;
    }

    public String getDefaultStateName() {
        return this.defaultStateName;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    @Override
    public boolean isTerminalState() {
        return false;
    }

    @Override
    public <T> T accept(StateVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements State.Builder {
        @JsonProperty(value="Comment")
        private String comment;
        @JsonProperty(value="Default")
        private String defaultStateName;
        @JsonProperty(value="Choices")
        private List<Choice.Builder> choices = new ArrayList<Choice.Builder>();
        @JsonProperty(value="InputPath")
        private String inputPath;
        @JsonProperty(value="OutputPath")
        private String outputPath;

        private Builder() {
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder defaultStateName(String defaultStateName) {
            this.defaultStateName = defaultStateName;
            return this;
        }

        public Builder choice(Choice.Builder choiceBuilder) {
            this.choices.add(choiceBuilder);
            return this;
        }

        public Builder choices(Choice.Builder ... choiceBuilders) {
            for (Choice.Builder choiceBuilder : choiceBuilders) {
                this.choices.add(choiceBuilder);
            }
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        @Override
        public ChoiceState build() {
            return new ChoiceState(this);
        }
    }
}

