/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.sns.model.ListTopicsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListTopicsRequestMarshaller
implements Marshaller<Request<ListTopicsRequest>, ListTopicsRequest> {
    @Override
    public Request<ListTopicsRequest> marshall(ListTopicsRequest listTopicsRequest) {
        if (listTopicsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListTopicsRequest> request = new DefaultRequest<ListTopicsRequest>(listTopicsRequest, "AmazonSNS");
        request.addParameter("Action", "ListTopics");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (listTopicsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(listTopicsRequest.getNextToken()));
        }
        return request;
    }
}

