/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.snowball.model.DataTransfer;

@SdkInternalApi
public class DataTransferMarshaller {
    private static final MarshallingInfo<Long> BYTESTRANSFERRED_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BytesTransferred").build();
    private static final MarshallingInfo<Long> OBJECTSTRANSFERRED_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectsTransferred").build();
    private static final MarshallingInfo<Long> TOTALBYTES_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalBytes").build();
    private static final MarshallingInfo<Long> TOTALOBJECTS_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalObjects").build();
    private static final DataTransferMarshaller instance = new DataTransferMarshaller();

    public static DataTransferMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataTransfer dataTransfer, ProtocolMarshaller protocolMarshaller) {
        if (dataTransfer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(dataTransfer.getBytesTransferred(), BYTESTRANSFERRED_BINDING);
            protocolMarshaller.marshall(dataTransfer.getObjectsTransferred(), OBJECTSTRANSFERRED_BINDING);
            protocolMarshaller.marshall(dataTransfer.getTotalBytes(), TOTALBYTES_BINDING);
            protocolMarshaller.marshall(dataTransfer.getTotalObjects(), TOTALOBJECTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

