/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.shield.model.SummarizedCounter;

@SdkInternalApi
public class SummarizedCounterMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<Double> MAX_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Max").build();
    private static final MarshallingInfo<Double> AVERAGE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Average").build();
    private static final MarshallingInfo<Double> SUM_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sum").build();
    private static final MarshallingInfo<Integer> N_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("N").build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Unit").build();
    private static final SummarizedCounterMarshaller instance = new SummarizedCounterMarshaller();

    public static SummarizedCounterMarshaller getInstance() {
        return instance;
    }

    public void marshall(SummarizedCounter summarizedCounter, ProtocolMarshaller protocolMarshaller) {
        if (summarizedCounter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(summarizedCounter.getName(), NAME_BINDING);
            protocolMarshaller.marshall(summarizedCounter.getMax(), MAX_BINDING);
            protocolMarshaller.marshall(summarizedCounter.getAverage(), AVERAGE_BINDING);
            protocolMarshaller.marshall(summarizedCounter.getSum(), SUM_BINDING);
            protocolMarshaller.marshall(summarizedCounter.getN(), N_BINDING);
            protocolMarshaller.marshall(summarizedCounter.getUnit(), UNIT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

