/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.route53domains.model.BillingRecord;
import java.util.Date;

@SdkInternalApi
public class BillingRecordMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").build();
    private static final MarshallingInfo<String> OPERATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Operation").build();
    private static final MarshallingInfo<String> INVOICEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InvoiceId").build();
    private static final MarshallingInfo<Date> BILLDATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BillDate").build();
    private static final MarshallingInfo<Double> PRICE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Price").build();
    private static final BillingRecordMarshaller instance = new BillingRecordMarshaller();

    public static BillingRecordMarshaller getInstance() {
        return instance;
    }

    public void marshall(BillingRecord billingRecord, ProtocolMarshaller protocolMarshaller) {
        if (billingRecord == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(billingRecord.getDomainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall(billingRecord.getOperation(), OPERATION_BINDING);
            protocolMarshaller.marshall(billingRecord.getInvoiceId(), INVOICEID_BINDING);
            protocolMarshaller.marshall(billingRecord.getBillDate(), BILLDATE_BINDING);
            protocolMarshaller.marshall(billingRecord.getPrice(), PRICE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

