/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53.model.ComparisonOperator;
import com.amazonaws.services.route53.model.Dimension;
import com.amazonaws.services.route53.model.Statistic;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CloudWatchAlarmConfiguration
implements Serializable,
Cloneable {
    private Integer evaluationPeriods;
    private Double threshold;
    private String comparisonOperator;
    private Integer period;
    private String metricName;
    private String namespace;
    private String statistic;
    private SdkInternalList<Dimension> dimensions;

    public void setEvaluationPeriods(Integer evaluationPeriods) {
        this.evaluationPeriods = evaluationPeriods;
    }

    public Integer getEvaluationPeriods() {
        return this.evaluationPeriods;
    }

    public CloudWatchAlarmConfiguration withEvaluationPeriods(Integer evaluationPeriods) {
        this.setEvaluationPeriods(evaluationPeriods);
        return this;
    }

    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public CloudWatchAlarmConfiguration withThreshold(Double threshold) {
        this.setThreshold(threshold);
        return this;
    }

    public void setComparisonOperator(String comparisonOperator) {
        this.comparisonOperator = comparisonOperator;
    }

    public String getComparisonOperator() {
        return this.comparisonOperator;
    }

    public CloudWatchAlarmConfiguration withComparisonOperator(String comparisonOperator) {
        this.setComparisonOperator(comparisonOperator);
        return this;
    }

    public void setComparisonOperator(ComparisonOperator comparisonOperator) {
        this.comparisonOperator = comparisonOperator.toString();
    }

    public CloudWatchAlarmConfiguration withComparisonOperator(ComparisonOperator comparisonOperator) {
        this.setComparisonOperator(comparisonOperator);
        return this;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public CloudWatchAlarmConfiguration withPeriod(Integer period) {
        this.setPeriod(period);
        return this;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public CloudWatchAlarmConfiguration withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public CloudWatchAlarmConfiguration withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public void setStatistic(String statistic) {
        this.statistic = statistic;
    }

    public String getStatistic() {
        return this.statistic;
    }

    public CloudWatchAlarmConfiguration withStatistic(String statistic) {
        this.setStatistic(statistic);
        return this;
    }

    public void setStatistic(Statistic statistic) {
        this.statistic = statistic.toString();
    }

    public CloudWatchAlarmConfiguration withStatistic(Statistic statistic) {
        this.setStatistic(statistic);
        return this;
    }

    public List<Dimension> getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = new SdkInternalList();
        }
        return this.dimensions;
    }

    public void setDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        this.dimensions = new SdkInternalList<Dimension>(dimensions);
    }

    public CloudWatchAlarmConfiguration withDimensions(Dimension ... dimensions) {
        if (this.dimensions == null) {
            this.setDimensions(new SdkInternalList<Dimension>(dimensions.length));
        }
        for (Dimension ele : dimensions) {
            this.dimensions.add(ele);
        }
        return this;
    }

    public CloudWatchAlarmConfiguration withDimensions(Collection<Dimension> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvaluationPeriods() != null) {
            sb.append("EvaluationPeriods: ").append(this.getEvaluationPeriods()).append(",");
        }
        if (this.getThreshold() != null) {
            sb.append("Threshold: ").append(this.getThreshold()).append(",");
        }
        if (this.getComparisonOperator() != null) {
            sb.append("ComparisonOperator: ").append(this.getComparisonOperator()).append(",");
        }
        if (this.getPeriod() != null) {
            sb.append("Period: ").append(this.getPeriod()).append(",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getStatistic() != null) {
            sb.append("Statistic: ").append(this.getStatistic()).append(",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchAlarmConfiguration)) {
            return false;
        }
        CloudWatchAlarmConfiguration other = (CloudWatchAlarmConfiguration)obj;
        if (other.getEvaluationPeriods() == null ^ this.getEvaluationPeriods() == null) {
            return false;
        }
        if (other.getEvaluationPeriods() != null && !other.getEvaluationPeriods().equals(this.getEvaluationPeriods())) {
            return false;
        }
        if (other.getThreshold() == null ^ this.getThreshold() == null) {
            return false;
        }
        if (other.getThreshold() != null && !other.getThreshold().equals(this.getThreshold())) {
            return false;
        }
        if (other.getComparisonOperator() == null ^ this.getComparisonOperator() == null) {
            return false;
        }
        if (other.getComparisonOperator() != null && !other.getComparisonOperator().equals(this.getComparisonOperator())) {
            return false;
        }
        if (other.getPeriod() == null ^ this.getPeriod() == null) {
            return false;
        }
        if (other.getPeriod() != null && !other.getPeriod().equals(this.getPeriod())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getStatistic() == null ^ this.getStatistic() == null) {
            return false;
        }
        if (other.getStatistic() != null && !other.getStatistic().equals(this.getStatistic())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        return other.getDimensions() == null || other.getDimensions().equals(this.getDimensions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvaluationPeriods() == null ? 0 : this.getEvaluationPeriods().hashCode());
        hashCode = 31 * hashCode + (this.getThreshold() == null ? 0 : this.getThreshold().hashCode());
        hashCode = 31 * hashCode + (this.getComparisonOperator() == null ? 0 : this.getComparisonOperator().hashCode());
        hashCode = 31 * hashCode + (this.getPeriod() == null ? 0 : this.getPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getStatistic() == null ? 0 : this.getStatistic().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        return hashCode;
    }

    public CloudWatchAlarmConfiguration clone() {
        try {
            return (CloudWatchAlarmConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

