/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.rekognition.model.ImageQuality;

@SdkInternalApi
public class ImageQualityMarshaller {
    private static final MarshallingInfo<Float> BRIGHTNESS_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Brightness").build();
    private static final MarshallingInfo<Float> SHARPNESS_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sharpness").build();
    private static final ImageQualityMarshaller instance = new ImageQualityMarshaller();

    public static ImageQualityMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImageQuality imageQuality, ProtocolMarshaller protocolMarshaller) {
        if (imageQuality == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(imageQuality.getBrightness(), BRIGHTNESS_BINDING);
            protocolMarshaller.marshall(imageQuality.getSharpness(), SHARPNESS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

