/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CreateOptionGroupRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateOptionGroupRequestMarshaller
implements Marshaller<Request<CreateOptionGroupRequest>, CreateOptionGroupRequest> {
    @Override
    public Request<CreateOptionGroupRequest> marshall(CreateOptionGroupRequest createOptionGroupRequest) {
        SdkInternalList tagsList;
        if (createOptionGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateOptionGroupRequest> request = new DefaultRequest<CreateOptionGroupRequest>(createOptionGroupRequest, "AmazonRDS");
        request.addParameter("Action", "CreateOptionGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createOptionGroupRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString(createOptionGroupRequest.getOptionGroupName()));
        }
        if (createOptionGroupRequest.getEngineName() != null) {
            request.addParameter("EngineName", StringUtils.fromString(createOptionGroupRequest.getEngineName()));
        }
        if (createOptionGroupRequest.getMajorEngineVersion() != null) {
            request.addParameter("MajorEngineVersion", StringUtils.fromString(createOptionGroupRequest.getMajorEngineVersion()));
        }
        if (createOptionGroupRequest.getOptionGroupDescription() != null) {
            request.addParameter("OptionGroupDescription", StringUtils.fromString(createOptionGroupRequest.getOptionGroupDescription()));
        }
        if (!(tagsList = (SdkInternalList)createOptionGroupRequest.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

