/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.lightsail.AmazonLightsailAsync;
import com.amazonaws.services.lightsail.AmazonLightsailAsyncClientBuilder;
import com.amazonaws.services.lightsail.AmazonLightsailClient;
import com.amazonaws.services.lightsail.model.AllocateStaticIpRequest;
import com.amazonaws.services.lightsail.model.AllocateStaticIpResult;
import com.amazonaws.services.lightsail.model.AttachStaticIpRequest;
import com.amazonaws.services.lightsail.model.AttachStaticIpResult;
import com.amazonaws.services.lightsail.model.CloseInstancePublicPortsRequest;
import com.amazonaws.services.lightsail.model.CloseInstancePublicPortsResult;
import com.amazonaws.services.lightsail.model.CreateDomainEntryRequest;
import com.amazonaws.services.lightsail.model.CreateDomainEntryResult;
import com.amazonaws.services.lightsail.model.CreateDomainRequest;
import com.amazonaws.services.lightsail.model.CreateDomainResult;
import com.amazonaws.services.lightsail.model.CreateInstanceSnapshotRequest;
import com.amazonaws.services.lightsail.model.CreateInstanceSnapshotResult;
import com.amazonaws.services.lightsail.model.CreateInstancesFromSnapshotRequest;
import com.amazonaws.services.lightsail.model.CreateInstancesFromSnapshotResult;
import com.amazonaws.services.lightsail.model.CreateInstancesRequest;
import com.amazonaws.services.lightsail.model.CreateInstancesResult;
import com.amazonaws.services.lightsail.model.CreateKeyPairRequest;
import com.amazonaws.services.lightsail.model.CreateKeyPairResult;
import com.amazonaws.services.lightsail.model.DeleteDomainEntryRequest;
import com.amazonaws.services.lightsail.model.DeleteDomainEntryResult;
import com.amazonaws.services.lightsail.model.DeleteDomainRequest;
import com.amazonaws.services.lightsail.model.DeleteDomainResult;
import com.amazonaws.services.lightsail.model.DeleteInstanceRequest;
import com.amazonaws.services.lightsail.model.DeleteInstanceResult;
import com.amazonaws.services.lightsail.model.DeleteInstanceSnapshotRequest;
import com.amazonaws.services.lightsail.model.DeleteInstanceSnapshotResult;
import com.amazonaws.services.lightsail.model.DeleteKeyPairRequest;
import com.amazonaws.services.lightsail.model.DeleteKeyPairResult;
import com.amazonaws.services.lightsail.model.DetachStaticIpRequest;
import com.amazonaws.services.lightsail.model.DetachStaticIpResult;
import com.amazonaws.services.lightsail.model.DownloadDefaultKeyPairRequest;
import com.amazonaws.services.lightsail.model.DownloadDefaultKeyPairResult;
import com.amazonaws.services.lightsail.model.GetActiveNamesRequest;
import com.amazonaws.services.lightsail.model.GetActiveNamesResult;
import com.amazonaws.services.lightsail.model.GetBlueprintsRequest;
import com.amazonaws.services.lightsail.model.GetBlueprintsResult;
import com.amazonaws.services.lightsail.model.GetBundlesRequest;
import com.amazonaws.services.lightsail.model.GetBundlesResult;
import com.amazonaws.services.lightsail.model.GetDomainRequest;
import com.amazonaws.services.lightsail.model.GetDomainResult;
import com.amazonaws.services.lightsail.model.GetDomainsRequest;
import com.amazonaws.services.lightsail.model.GetDomainsResult;
import com.amazonaws.services.lightsail.model.GetInstanceAccessDetailsRequest;
import com.amazonaws.services.lightsail.model.GetInstanceAccessDetailsResult;
import com.amazonaws.services.lightsail.model.GetInstanceMetricDataRequest;
import com.amazonaws.services.lightsail.model.GetInstanceMetricDataResult;
import com.amazonaws.services.lightsail.model.GetInstancePortStatesRequest;
import com.amazonaws.services.lightsail.model.GetInstancePortStatesResult;
import com.amazonaws.services.lightsail.model.GetInstanceRequest;
import com.amazonaws.services.lightsail.model.GetInstanceResult;
import com.amazonaws.services.lightsail.model.GetInstanceSnapshotRequest;
import com.amazonaws.services.lightsail.model.GetInstanceSnapshotResult;
import com.amazonaws.services.lightsail.model.GetInstanceSnapshotsRequest;
import com.amazonaws.services.lightsail.model.GetInstanceSnapshotsResult;
import com.amazonaws.services.lightsail.model.GetInstanceStateRequest;
import com.amazonaws.services.lightsail.model.GetInstanceStateResult;
import com.amazonaws.services.lightsail.model.GetInstancesRequest;
import com.amazonaws.services.lightsail.model.GetInstancesResult;
import com.amazonaws.services.lightsail.model.GetKeyPairRequest;
import com.amazonaws.services.lightsail.model.GetKeyPairResult;
import com.amazonaws.services.lightsail.model.GetKeyPairsRequest;
import com.amazonaws.services.lightsail.model.GetKeyPairsResult;
import com.amazonaws.services.lightsail.model.GetOperationRequest;
import com.amazonaws.services.lightsail.model.GetOperationResult;
import com.amazonaws.services.lightsail.model.GetOperationsForResourceRequest;
import com.amazonaws.services.lightsail.model.GetOperationsForResourceResult;
import com.amazonaws.services.lightsail.model.GetOperationsRequest;
import com.amazonaws.services.lightsail.model.GetOperationsResult;
import com.amazonaws.services.lightsail.model.GetRegionsRequest;
import com.amazonaws.services.lightsail.model.GetRegionsResult;
import com.amazonaws.services.lightsail.model.GetStaticIpRequest;
import com.amazonaws.services.lightsail.model.GetStaticIpResult;
import com.amazonaws.services.lightsail.model.GetStaticIpsRequest;
import com.amazonaws.services.lightsail.model.GetStaticIpsResult;
import com.amazonaws.services.lightsail.model.ImportKeyPairRequest;
import com.amazonaws.services.lightsail.model.ImportKeyPairResult;
import com.amazonaws.services.lightsail.model.IsVpcPeeredRequest;
import com.amazonaws.services.lightsail.model.IsVpcPeeredResult;
import com.amazonaws.services.lightsail.model.OpenInstancePublicPortsRequest;
import com.amazonaws.services.lightsail.model.OpenInstancePublicPortsResult;
import com.amazonaws.services.lightsail.model.PeerVpcRequest;
import com.amazonaws.services.lightsail.model.PeerVpcResult;
import com.amazonaws.services.lightsail.model.RebootInstanceRequest;
import com.amazonaws.services.lightsail.model.RebootInstanceResult;
import com.amazonaws.services.lightsail.model.ReleaseStaticIpRequest;
import com.amazonaws.services.lightsail.model.ReleaseStaticIpResult;
import com.amazonaws.services.lightsail.model.StartInstanceRequest;
import com.amazonaws.services.lightsail.model.StartInstanceResult;
import com.amazonaws.services.lightsail.model.StopInstanceRequest;
import com.amazonaws.services.lightsail.model.StopInstanceResult;
import com.amazonaws.services.lightsail.model.UnpeerVpcRequest;
import com.amazonaws.services.lightsail.model.UnpeerVpcResult;
import com.amazonaws.services.lightsail.model.UpdateDomainEntryRequest;
import com.amazonaws.services.lightsail.model.UpdateDomainEntryResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonLightsailAsyncClient
extends AmazonLightsailClient
implements AmazonLightsailAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonLightsailAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonLightsailAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonLightsailAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonLightsailAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonLightsailAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonLightsailAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonLightsailAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonLightsailAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonLightsailAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonLightsailAsyncClientBuilder asyncBuilder() {
        return AmazonLightsailAsyncClientBuilder.standard();
    }

    AmazonLightsailAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AllocateStaticIpResult> allocateStaticIpAsync(AllocateStaticIpRequest request) {
        return this.allocateStaticIpAsync(request, null);
    }

    @Override
    public Future<AllocateStaticIpResult> allocateStaticIpAsync(AllocateStaticIpRequest request, final AsyncHandler<AllocateStaticIpRequest, AllocateStaticIpResult> asyncHandler) {
        final AllocateStaticIpRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AllocateStaticIpResult>(){

            @Override
            public AllocateStaticIpResult call() throws Exception {
                AllocateStaticIpResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeAllocateStaticIp(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AttachStaticIpResult> attachStaticIpAsync(AttachStaticIpRequest request) {
        return this.attachStaticIpAsync(request, null);
    }

    @Override
    public Future<AttachStaticIpResult> attachStaticIpAsync(AttachStaticIpRequest request, final AsyncHandler<AttachStaticIpRequest, AttachStaticIpResult> asyncHandler) {
        final AttachStaticIpRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AttachStaticIpResult>(){

            @Override
            public AttachStaticIpResult call() throws Exception {
                AttachStaticIpResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeAttachStaticIp(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CloseInstancePublicPortsResult> closeInstancePublicPortsAsync(CloseInstancePublicPortsRequest request) {
        return this.closeInstancePublicPortsAsync(request, null);
    }

    @Override
    public Future<CloseInstancePublicPortsResult> closeInstancePublicPortsAsync(CloseInstancePublicPortsRequest request, final AsyncHandler<CloseInstancePublicPortsRequest, CloseInstancePublicPortsResult> asyncHandler) {
        final CloseInstancePublicPortsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CloseInstancePublicPortsResult>(){

            @Override
            public CloseInstancePublicPortsResult call() throws Exception {
                CloseInstancePublicPortsResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeCloseInstancePublicPorts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDomainResult> createDomainAsync(CreateDomainRequest request) {
        return this.createDomainAsync(request, null);
    }

    @Override
    public Future<CreateDomainResult> createDomainAsync(CreateDomainRequest request, final AsyncHandler<CreateDomainRequest, CreateDomainResult> asyncHandler) {
        final CreateDomainRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDomainResult>(){

            @Override
            public CreateDomainResult call() throws Exception {
                CreateDomainResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeCreateDomain(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDomainEntryResult> createDomainEntryAsync(CreateDomainEntryRequest request) {
        return this.createDomainEntryAsync(request, null);
    }

    @Override
    public Future<CreateDomainEntryResult> createDomainEntryAsync(CreateDomainEntryRequest request, final AsyncHandler<CreateDomainEntryRequest, CreateDomainEntryResult> asyncHandler) {
        final CreateDomainEntryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDomainEntryResult>(){

            @Override
            public CreateDomainEntryResult call() throws Exception {
                CreateDomainEntryResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeCreateDomainEntry(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateInstanceSnapshotResult> createInstanceSnapshotAsync(CreateInstanceSnapshotRequest request) {
        return this.createInstanceSnapshotAsync(request, null);
    }

    @Override
    public Future<CreateInstanceSnapshotResult> createInstanceSnapshotAsync(CreateInstanceSnapshotRequest request, final AsyncHandler<CreateInstanceSnapshotRequest, CreateInstanceSnapshotResult> asyncHandler) {
        final CreateInstanceSnapshotRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateInstanceSnapshotResult>(){

            @Override
            public CreateInstanceSnapshotResult call() throws Exception {
                CreateInstanceSnapshotResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeCreateInstanceSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateInstancesResult> createInstancesAsync(CreateInstancesRequest request) {
        return this.createInstancesAsync(request, null);
    }

    @Override
    public Future<CreateInstancesResult> createInstancesAsync(CreateInstancesRequest request, final AsyncHandler<CreateInstancesRequest, CreateInstancesResult> asyncHandler) {
        final CreateInstancesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateInstancesResult>(){

            @Override
            public CreateInstancesResult call() throws Exception {
                CreateInstancesResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeCreateInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateInstancesFromSnapshotResult> createInstancesFromSnapshotAsync(CreateInstancesFromSnapshotRequest request) {
        return this.createInstancesFromSnapshotAsync(request, null);
    }

    @Override
    public Future<CreateInstancesFromSnapshotResult> createInstancesFromSnapshotAsync(CreateInstancesFromSnapshotRequest request, final AsyncHandler<CreateInstancesFromSnapshotRequest, CreateInstancesFromSnapshotResult> asyncHandler) {
        final CreateInstancesFromSnapshotRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateInstancesFromSnapshotResult>(){

            @Override
            public CreateInstancesFromSnapshotResult call() throws Exception {
                CreateInstancesFromSnapshotResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeCreateInstancesFromSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateKeyPairResult> createKeyPairAsync(CreateKeyPairRequest request) {
        return this.createKeyPairAsync(request, null);
    }

    @Override
    public Future<CreateKeyPairResult> createKeyPairAsync(CreateKeyPairRequest request, final AsyncHandler<CreateKeyPairRequest, CreateKeyPairResult> asyncHandler) {
        final CreateKeyPairRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateKeyPairResult>(){

            @Override
            public CreateKeyPairResult call() throws Exception {
                CreateKeyPairResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeCreateKeyPair(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDomainResult> deleteDomainAsync(DeleteDomainRequest request) {
        return this.deleteDomainAsync(request, null);
    }

    @Override
    public Future<DeleteDomainResult> deleteDomainAsync(DeleteDomainRequest request, final AsyncHandler<DeleteDomainRequest, DeleteDomainResult> asyncHandler) {
        final DeleteDomainRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDomainResult>(){

            @Override
            public DeleteDomainResult call() throws Exception {
                DeleteDomainResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeDeleteDomain(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDomainEntryResult> deleteDomainEntryAsync(DeleteDomainEntryRequest request) {
        return this.deleteDomainEntryAsync(request, null);
    }

    @Override
    public Future<DeleteDomainEntryResult> deleteDomainEntryAsync(DeleteDomainEntryRequest request, final AsyncHandler<DeleteDomainEntryRequest, DeleteDomainEntryResult> asyncHandler) {
        final DeleteDomainEntryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDomainEntryResult>(){

            @Override
            public DeleteDomainEntryResult call() throws Exception {
                DeleteDomainEntryResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeDeleteDomainEntry(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteInstanceResult> deleteInstanceAsync(DeleteInstanceRequest request) {
        return this.deleteInstanceAsync(request, null);
    }

    @Override
    public Future<DeleteInstanceResult> deleteInstanceAsync(DeleteInstanceRequest request, final AsyncHandler<DeleteInstanceRequest, DeleteInstanceResult> asyncHandler) {
        final DeleteInstanceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteInstanceResult>(){

            @Override
            public DeleteInstanceResult call() throws Exception {
                DeleteInstanceResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeDeleteInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteInstanceSnapshotResult> deleteInstanceSnapshotAsync(DeleteInstanceSnapshotRequest request) {
        return this.deleteInstanceSnapshotAsync(request, null);
    }

    @Override
    public Future<DeleteInstanceSnapshotResult> deleteInstanceSnapshotAsync(DeleteInstanceSnapshotRequest request, final AsyncHandler<DeleteInstanceSnapshotRequest, DeleteInstanceSnapshotResult> asyncHandler) {
        final DeleteInstanceSnapshotRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteInstanceSnapshotResult>(){

            @Override
            public DeleteInstanceSnapshotResult call() throws Exception {
                DeleteInstanceSnapshotResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeDeleteInstanceSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteKeyPairResult> deleteKeyPairAsync(DeleteKeyPairRequest request) {
        return this.deleteKeyPairAsync(request, null);
    }

    @Override
    public Future<DeleteKeyPairResult> deleteKeyPairAsync(DeleteKeyPairRequest request, final AsyncHandler<DeleteKeyPairRequest, DeleteKeyPairResult> asyncHandler) {
        final DeleteKeyPairRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteKeyPairResult>(){

            @Override
            public DeleteKeyPairResult call() throws Exception {
                DeleteKeyPairResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeDeleteKeyPair(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetachStaticIpResult> detachStaticIpAsync(DetachStaticIpRequest request) {
        return this.detachStaticIpAsync(request, null);
    }

    @Override
    public Future<DetachStaticIpResult> detachStaticIpAsync(DetachStaticIpRequest request, final AsyncHandler<DetachStaticIpRequest, DetachStaticIpResult> asyncHandler) {
        final DetachStaticIpRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetachStaticIpResult>(){

            @Override
            public DetachStaticIpResult call() throws Exception {
                DetachStaticIpResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeDetachStaticIp(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DownloadDefaultKeyPairResult> downloadDefaultKeyPairAsync(DownloadDefaultKeyPairRequest request) {
        return this.downloadDefaultKeyPairAsync(request, null);
    }

    @Override
    public Future<DownloadDefaultKeyPairResult> downloadDefaultKeyPairAsync(DownloadDefaultKeyPairRequest request, final AsyncHandler<DownloadDefaultKeyPairRequest, DownloadDefaultKeyPairResult> asyncHandler) {
        final DownloadDefaultKeyPairRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DownloadDefaultKeyPairResult>(){

            @Override
            public DownloadDefaultKeyPairResult call() throws Exception {
                DownloadDefaultKeyPairResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeDownloadDefaultKeyPair(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetActiveNamesResult> getActiveNamesAsync(GetActiveNamesRequest request) {
        return this.getActiveNamesAsync(request, null);
    }

    @Override
    public Future<GetActiveNamesResult> getActiveNamesAsync(GetActiveNamesRequest request, final AsyncHandler<GetActiveNamesRequest, GetActiveNamesResult> asyncHandler) {
        final GetActiveNamesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetActiveNamesResult>(){

            @Override
            public GetActiveNamesResult call() throws Exception {
                GetActiveNamesResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetActiveNames(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBlueprintsResult> getBlueprintsAsync(GetBlueprintsRequest request) {
        return this.getBlueprintsAsync(request, null);
    }

    @Override
    public Future<GetBlueprintsResult> getBlueprintsAsync(GetBlueprintsRequest request, final AsyncHandler<GetBlueprintsRequest, GetBlueprintsResult> asyncHandler) {
        final GetBlueprintsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBlueprintsResult>(){

            @Override
            public GetBlueprintsResult call() throws Exception {
                GetBlueprintsResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetBlueprints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBundlesResult> getBundlesAsync(GetBundlesRequest request) {
        return this.getBundlesAsync(request, null);
    }

    @Override
    public Future<GetBundlesResult> getBundlesAsync(GetBundlesRequest request, final AsyncHandler<GetBundlesRequest, GetBundlesResult> asyncHandler) {
        final GetBundlesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBundlesResult>(){

            @Override
            public GetBundlesResult call() throws Exception {
                GetBundlesResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetBundles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDomainResult> getDomainAsync(GetDomainRequest request) {
        return this.getDomainAsync(request, null);
    }

    @Override
    public Future<GetDomainResult> getDomainAsync(GetDomainRequest request, final AsyncHandler<GetDomainRequest, GetDomainResult> asyncHandler) {
        final GetDomainRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDomainResult>(){

            @Override
            public GetDomainResult call() throws Exception {
                GetDomainResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetDomain(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDomainsResult> getDomainsAsync(GetDomainsRequest request) {
        return this.getDomainsAsync(request, null);
    }

    @Override
    public Future<GetDomainsResult> getDomainsAsync(GetDomainsRequest request, final AsyncHandler<GetDomainsRequest, GetDomainsResult> asyncHandler) {
        final GetDomainsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDomainsResult>(){

            @Override
            public GetDomainsResult call() throws Exception {
                GetDomainsResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetDomains(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInstanceResult> getInstanceAsync(GetInstanceRequest request) {
        return this.getInstanceAsync(request, null);
    }

    @Override
    public Future<GetInstanceResult> getInstanceAsync(GetInstanceRequest request, final AsyncHandler<GetInstanceRequest, GetInstanceResult> asyncHandler) {
        final GetInstanceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetInstanceResult>(){

            @Override
            public GetInstanceResult call() throws Exception {
                GetInstanceResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInstanceAccessDetailsResult> getInstanceAccessDetailsAsync(GetInstanceAccessDetailsRequest request) {
        return this.getInstanceAccessDetailsAsync(request, null);
    }

    @Override
    public Future<GetInstanceAccessDetailsResult> getInstanceAccessDetailsAsync(GetInstanceAccessDetailsRequest request, final AsyncHandler<GetInstanceAccessDetailsRequest, GetInstanceAccessDetailsResult> asyncHandler) {
        final GetInstanceAccessDetailsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetInstanceAccessDetailsResult>(){

            @Override
            public GetInstanceAccessDetailsResult call() throws Exception {
                GetInstanceAccessDetailsResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetInstanceAccessDetails(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInstanceMetricDataResult> getInstanceMetricDataAsync(GetInstanceMetricDataRequest request) {
        return this.getInstanceMetricDataAsync(request, null);
    }

    @Override
    public Future<GetInstanceMetricDataResult> getInstanceMetricDataAsync(GetInstanceMetricDataRequest request, final AsyncHandler<GetInstanceMetricDataRequest, GetInstanceMetricDataResult> asyncHandler) {
        final GetInstanceMetricDataRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetInstanceMetricDataResult>(){

            @Override
            public GetInstanceMetricDataResult call() throws Exception {
                GetInstanceMetricDataResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetInstanceMetricData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInstancePortStatesResult> getInstancePortStatesAsync(GetInstancePortStatesRequest request) {
        return this.getInstancePortStatesAsync(request, null);
    }

    @Override
    public Future<GetInstancePortStatesResult> getInstancePortStatesAsync(GetInstancePortStatesRequest request, final AsyncHandler<GetInstancePortStatesRequest, GetInstancePortStatesResult> asyncHandler) {
        final GetInstancePortStatesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetInstancePortStatesResult>(){

            @Override
            public GetInstancePortStatesResult call() throws Exception {
                GetInstancePortStatesResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetInstancePortStates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInstanceSnapshotResult> getInstanceSnapshotAsync(GetInstanceSnapshotRequest request) {
        return this.getInstanceSnapshotAsync(request, null);
    }

    @Override
    public Future<GetInstanceSnapshotResult> getInstanceSnapshotAsync(GetInstanceSnapshotRequest request, final AsyncHandler<GetInstanceSnapshotRequest, GetInstanceSnapshotResult> asyncHandler) {
        final GetInstanceSnapshotRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetInstanceSnapshotResult>(){

            @Override
            public GetInstanceSnapshotResult call() throws Exception {
                GetInstanceSnapshotResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetInstanceSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInstanceSnapshotsResult> getInstanceSnapshotsAsync(GetInstanceSnapshotsRequest request) {
        return this.getInstanceSnapshotsAsync(request, null);
    }

    @Override
    public Future<GetInstanceSnapshotsResult> getInstanceSnapshotsAsync(GetInstanceSnapshotsRequest request, final AsyncHandler<GetInstanceSnapshotsRequest, GetInstanceSnapshotsResult> asyncHandler) {
        final GetInstanceSnapshotsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetInstanceSnapshotsResult>(){

            @Override
            public GetInstanceSnapshotsResult call() throws Exception {
                GetInstanceSnapshotsResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetInstanceSnapshots(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInstanceStateResult> getInstanceStateAsync(GetInstanceStateRequest request) {
        return this.getInstanceStateAsync(request, null);
    }

    @Override
    public Future<GetInstanceStateResult> getInstanceStateAsync(GetInstanceStateRequest request, final AsyncHandler<GetInstanceStateRequest, GetInstanceStateResult> asyncHandler) {
        final GetInstanceStateRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetInstanceStateResult>(){

            @Override
            public GetInstanceStateResult call() throws Exception {
                GetInstanceStateResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetInstanceState(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetInstancesResult> getInstancesAsync(GetInstancesRequest request) {
        return this.getInstancesAsync(request, null);
    }

    @Override
    public Future<GetInstancesResult> getInstancesAsync(GetInstancesRequest request, final AsyncHandler<GetInstancesRequest, GetInstancesResult> asyncHandler) {
        final GetInstancesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetInstancesResult>(){

            @Override
            public GetInstancesResult call() throws Exception {
                GetInstancesResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetKeyPairResult> getKeyPairAsync(GetKeyPairRequest request) {
        return this.getKeyPairAsync(request, null);
    }

    @Override
    public Future<GetKeyPairResult> getKeyPairAsync(GetKeyPairRequest request, final AsyncHandler<GetKeyPairRequest, GetKeyPairResult> asyncHandler) {
        final GetKeyPairRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetKeyPairResult>(){

            @Override
            public GetKeyPairResult call() throws Exception {
                GetKeyPairResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetKeyPair(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetKeyPairsResult> getKeyPairsAsync(GetKeyPairsRequest request) {
        return this.getKeyPairsAsync(request, null);
    }

    @Override
    public Future<GetKeyPairsResult> getKeyPairsAsync(GetKeyPairsRequest request, final AsyncHandler<GetKeyPairsRequest, GetKeyPairsResult> asyncHandler) {
        final GetKeyPairsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetKeyPairsResult>(){

            @Override
            public GetKeyPairsResult call() throws Exception {
                GetKeyPairsResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetKeyPairs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOperationResult> getOperationAsync(GetOperationRequest request) {
        return this.getOperationAsync(request, null);
    }

    @Override
    public Future<GetOperationResult> getOperationAsync(GetOperationRequest request, final AsyncHandler<GetOperationRequest, GetOperationResult> asyncHandler) {
        final GetOperationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOperationResult>(){

            @Override
            public GetOperationResult call() throws Exception {
                GetOperationResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetOperation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOperationsResult> getOperationsAsync(GetOperationsRequest request) {
        return this.getOperationsAsync(request, null);
    }

    @Override
    public Future<GetOperationsResult> getOperationsAsync(GetOperationsRequest request, final AsyncHandler<GetOperationsRequest, GetOperationsResult> asyncHandler) {
        final GetOperationsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOperationsResult>(){

            @Override
            public GetOperationsResult call() throws Exception {
                GetOperationsResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetOperations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOperationsForResourceResult> getOperationsForResourceAsync(GetOperationsForResourceRequest request) {
        return this.getOperationsForResourceAsync(request, null);
    }

    @Override
    public Future<GetOperationsForResourceResult> getOperationsForResourceAsync(GetOperationsForResourceRequest request, final AsyncHandler<GetOperationsForResourceRequest, GetOperationsForResourceResult> asyncHandler) {
        final GetOperationsForResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOperationsForResourceResult>(){

            @Override
            public GetOperationsForResourceResult call() throws Exception {
                GetOperationsForResourceResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetOperationsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRegionsResult> getRegionsAsync(GetRegionsRequest request) {
        return this.getRegionsAsync(request, null);
    }

    @Override
    public Future<GetRegionsResult> getRegionsAsync(GetRegionsRequest request, final AsyncHandler<GetRegionsRequest, GetRegionsResult> asyncHandler) {
        final GetRegionsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRegionsResult>(){

            @Override
            public GetRegionsResult call() throws Exception {
                GetRegionsResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetRegions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetStaticIpResult> getStaticIpAsync(GetStaticIpRequest request) {
        return this.getStaticIpAsync(request, null);
    }

    @Override
    public Future<GetStaticIpResult> getStaticIpAsync(GetStaticIpRequest request, final AsyncHandler<GetStaticIpRequest, GetStaticIpResult> asyncHandler) {
        final GetStaticIpRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetStaticIpResult>(){

            @Override
            public GetStaticIpResult call() throws Exception {
                GetStaticIpResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetStaticIp(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetStaticIpsResult> getStaticIpsAsync(GetStaticIpsRequest request) {
        return this.getStaticIpsAsync(request, null);
    }

    @Override
    public Future<GetStaticIpsResult> getStaticIpsAsync(GetStaticIpsRequest request, final AsyncHandler<GetStaticIpsRequest, GetStaticIpsResult> asyncHandler) {
        final GetStaticIpsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetStaticIpsResult>(){

            @Override
            public GetStaticIpsResult call() throws Exception {
                GetStaticIpsResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeGetStaticIps(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ImportKeyPairResult> importKeyPairAsync(ImportKeyPairRequest request) {
        return this.importKeyPairAsync(request, null);
    }

    @Override
    public Future<ImportKeyPairResult> importKeyPairAsync(ImportKeyPairRequest request, final AsyncHandler<ImportKeyPairRequest, ImportKeyPairResult> asyncHandler) {
        final ImportKeyPairRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ImportKeyPairResult>(){

            @Override
            public ImportKeyPairResult call() throws Exception {
                ImportKeyPairResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeImportKeyPair(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<IsVpcPeeredResult> isVpcPeeredAsync(IsVpcPeeredRequest request) {
        return this.isVpcPeeredAsync(request, null);
    }

    @Override
    public Future<IsVpcPeeredResult> isVpcPeeredAsync(IsVpcPeeredRequest request, final AsyncHandler<IsVpcPeeredRequest, IsVpcPeeredResult> asyncHandler) {
        final IsVpcPeeredRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<IsVpcPeeredResult>(){

            @Override
            public IsVpcPeeredResult call() throws Exception {
                IsVpcPeeredResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeIsVpcPeered(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<OpenInstancePublicPortsResult> openInstancePublicPortsAsync(OpenInstancePublicPortsRequest request) {
        return this.openInstancePublicPortsAsync(request, null);
    }

    @Override
    public Future<OpenInstancePublicPortsResult> openInstancePublicPortsAsync(OpenInstancePublicPortsRequest request, final AsyncHandler<OpenInstancePublicPortsRequest, OpenInstancePublicPortsResult> asyncHandler) {
        final OpenInstancePublicPortsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<OpenInstancePublicPortsResult>(){

            @Override
            public OpenInstancePublicPortsResult call() throws Exception {
                OpenInstancePublicPortsResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeOpenInstancePublicPorts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PeerVpcResult> peerVpcAsync(PeerVpcRequest request) {
        return this.peerVpcAsync(request, null);
    }

    @Override
    public Future<PeerVpcResult> peerVpcAsync(PeerVpcRequest request, final AsyncHandler<PeerVpcRequest, PeerVpcResult> asyncHandler) {
        final PeerVpcRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PeerVpcResult>(){

            @Override
            public PeerVpcResult call() throws Exception {
                PeerVpcResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executePeerVpc(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RebootInstanceResult> rebootInstanceAsync(RebootInstanceRequest request) {
        return this.rebootInstanceAsync(request, null);
    }

    @Override
    public Future<RebootInstanceResult> rebootInstanceAsync(RebootInstanceRequest request, final AsyncHandler<RebootInstanceRequest, RebootInstanceResult> asyncHandler) {
        final RebootInstanceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RebootInstanceResult>(){

            @Override
            public RebootInstanceResult call() throws Exception {
                RebootInstanceResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeRebootInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReleaseStaticIpResult> releaseStaticIpAsync(ReleaseStaticIpRequest request) {
        return this.releaseStaticIpAsync(request, null);
    }

    @Override
    public Future<ReleaseStaticIpResult> releaseStaticIpAsync(ReleaseStaticIpRequest request, final AsyncHandler<ReleaseStaticIpRequest, ReleaseStaticIpResult> asyncHandler) {
        final ReleaseStaticIpRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ReleaseStaticIpResult>(){

            @Override
            public ReleaseStaticIpResult call() throws Exception {
                ReleaseStaticIpResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeReleaseStaticIp(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartInstanceResult> startInstanceAsync(StartInstanceRequest request) {
        return this.startInstanceAsync(request, null);
    }

    @Override
    public Future<StartInstanceResult> startInstanceAsync(StartInstanceRequest request, final AsyncHandler<StartInstanceRequest, StartInstanceResult> asyncHandler) {
        final StartInstanceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartInstanceResult>(){

            @Override
            public StartInstanceResult call() throws Exception {
                StartInstanceResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeStartInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopInstanceResult> stopInstanceAsync(StopInstanceRequest request) {
        return this.stopInstanceAsync(request, null);
    }

    @Override
    public Future<StopInstanceResult> stopInstanceAsync(StopInstanceRequest request, final AsyncHandler<StopInstanceRequest, StopInstanceResult> asyncHandler) {
        final StopInstanceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopInstanceResult>(){

            @Override
            public StopInstanceResult call() throws Exception {
                StopInstanceResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeStopInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UnpeerVpcResult> unpeerVpcAsync(UnpeerVpcRequest request) {
        return this.unpeerVpcAsync(request, null);
    }

    @Override
    public Future<UnpeerVpcResult> unpeerVpcAsync(UnpeerVpcRequest request, final AsyncHandler<UnpeerVpcRequest, UnpeerVpcResult> asyncHandler) {
        final UnpeerVpcRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UnpeerVpcResult>(){

            @Override
            public UnpeerVpcResult call() throws Exception {
                UnpeerVpcResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeUnpeerVpc(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDomainEntryResult> updateDomainEntryAsync(UpdateDomainEntryRequest request) {
        return this.updateDomainEntryAsync(request, null);
    }

    @Override
    public Future<UpdateDomainEntryResult> updateDomainEntryAsync(UpdateDomainEntryRequest request, final AsyncHandler<UpdateDomainEntryRequest, UpdateDomainEntryResult> asyncHandler) {
        final UpdateDomainEntryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDomainEntryResult>(){

            @Override
            public UpdateDomainEntryResult call() throws Exception {
                UpdateDomainEntryResult result = null;
                try {
                    result = AmazonLightsailAsyncClient.this.executeUpdateDomainEntry(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

