/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.inspector.model.AgentPreview;

@SdkInternalApi
public class AgentPreviewMarshaller {
    private static final MarshallingInfo<String> AGENTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("agentId").build();
    private static final MarshallingInfo<String> AUTOSCALINGGROUP_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("autoScalingGroup").build();
    private static final AgentPreviewMarshaller instance = new AgentPreviewMarshaller();

    public static AgentPreviewMarshaller getInstance() {
        return instance;
    }

    public void marshall(AgentPreview agentPreview, ProtocolMarshaller protocolMarshaller) {
        if (agentPreview == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(agentPreview.getAgentId(), AGENTID_BINDING);
            protocolMarshaller.marshall(agentPreview.getAutoScalingGroup(), AUTOSCALINGGROUP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

