/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.services.identitymanagement.model.VirtualMFADevice;
import com.amazonaws.services.identitymanagement.model.transform.UserStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class VirtualMFADeviceStaxUnmarshaller
implements Unmarshaller<VirtualMFADevice, StaxUnmarshallerContext> {
    private static VirtualMFADeviceStaxUnmarshaller instance;

    @Override
    public VirtualMFADevice unmarshall(StaxUnmarshallerContext context) throws Exception {
        VirtualMFADevice virtualMFADevice = new VirtualMFADevice();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return virtualMFADevice;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SerialNumber", targetDepth)) {
                    virtualMFADevice.setSerialNumber(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Base32StringSeed", targetDepth)) {
                    virtualMFADevice.setBase32StringSeed(SimpleTypeStaxUnmarshallers.ByteBufferStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("QRCodePNG", targetDepth)) {
                    virtualMFADevice.setQRCodePNG(SimpleTypeStaxUnmarshallers.ByteBufferStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("User", targetDepth)) {
                    virtualMFADevice.setUser(UserStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EnableDate", targetDepth)) continue;
                virtualMFADevice.setEnableDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return virtualMFADevice;
    }

    public static VirtualMFADeviceStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new VirtualMFADeviceStaxUnmarshaller();
        }
        return instance;
    }
}

