/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.Action;
import com.amazonaws.services.elasticloadbalancingv2.model.Certificate;
import com.amazonaws.services.elasticloadbalancingv2.model.ModifyListenerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyListenerRequestMarshaller
implements Marshaller<Request<ModifyListenerRequest>, ModifyListenerRequest> {
    @Override
    public Request<ModifyListenerRequest> marshall(ModifyListenerRequest modifyListenerRequest) {
        List<Action> defaultActionsList;
        List<Certificate> certificatesList;
        if (modifyListenerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyListenerRequest> request = new DefaultRequest<ModifyListenerRequest>(modifyListenerRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ModifyListener");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyListenerRequest.getListenerArn() != null) {
            request.addParameter("ListenerArn", StringUtils.fromString(modifyListenerRequest.getListenerArn()));
        }
        if (modifyListenerRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger(modifyListenerRequest.getPort()));
        }
        if (modifyListenerRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString(modifyListenerRequest.getProtocol()));
        }
        if (modifyListenerRequest.getSslPolicy() != null) {
            request.addParameter("SslPolicy", StringUtils.fromString(modifyListenerRequest.getSslPolicy()));
        }
        if ((certificatesList = modifyListenerRequest.getCertificates()) != null) {
            if (certificatesList.isEmpty()) {
                request.addParameter("Certificates", "");
            } else {
                int certificatesListIndex = 1;
                for (Certificate certificatesListValue : certificatesList) {
                    if (certificatesListValue.getCertificateArn() != null) {
                        request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringUtils.fromString(certificatesListValue.getCertificateArn()));
                    }
                    ++certificatesListIndex;
                }
            }
        }
        if ((defaultActionsList = modifyListenerRequest.getDefaultActions()) != null) {
            if (defaultActionsList.isEmpty()) {
                request.addParameter("DefaultActions", "");
            } else {
                int defaultActionsListIndex = 1;
                for (Action defaultActionsListValue : defaultActionsList) {
                    if (defaultActionsListValue.getType() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".Type", StringUtils.fromString(defaultActionsListValue.getType()));
                    }
                    if (defaultActionsListValue.getTargetGroupArn() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".TargetGroupArn", StringUtils.fromString(defaultActionsListValue.getTargetGroupArn()));
                    }
                    ++defaultActionsListIndex;
                }
            }
        }
        return request;
    }
}

