/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateLoadBalancerRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerRequest>, CreateLoadBalancerRequest> {
    /*
     * WARNING - void declaration
     */
    @Override
    public Request<CreateLoadBalancerRequest> marshall(CreateLoadBalancerRequest createLoadBalancerRequest) {
        List<Tag> tagsList;
        List<String> securityGroupsList;
        List<String> subnetsList;
        if (createLoadBalancerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateLoadBalancerRequest> request = new DefaultRequest<CreateLoadBalancerRequest>(createLoadBalancerRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateLoadBalancer");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLoadBalancerRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString(createLoadBalancerRequest.getName()));
        }
        if ((subnetsList = createLoadBalancerRequest.getSubnets()) != null) {
            if (subnetsList.isEmpty()) {
                request.addParameter("Subnets", "");
            } else {
                int subnetsListIndex = 1;
                for (String string : subnetsList) {
                    if (string != null) {
                        request.addParameter("Subnets.member." + subnetsListIndex, StringUtils.fromString(string));
                    }
                    ++subnetsListIndex;
                }
            }
        }
        if ((securityGroupsList = createLoadBalancerRequest.getSecurityGroups()) != null) {
            if (securityGroupsList.isEmpty()) {
                request.addParameter("SecurityGroups", "");
            } else {
                int securityGroupsListIndex = 1;
                for (String securityGroupsListValue : securityGroupsList) {
                    if (securityGroupsListValue != null) {
                        request.addParameter("SecurityGroups.member." + securityGroupsListIndex, StringUtils.fromString(securityGroupsListValue));
                    }
                    ++securityGroupsListIndex;
                }
            }
        }
        if (createLoadBalancerRequest.getScheme() != null) {
            request.addParameter("Scheme", StringUtils.fromString(createLoadBalancerRequest.getScheme()));
        }
        if ((tagsList = createLoadBalancerRequest.getTags()) != null) {
            if (tagsList.isEmpty()) {
                request.addParameter("Tags", "");
            } else {
                boolean bl = true;
                for (Tag tagsListValue : tagsList) {
                    void var6_12;
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + (int)var6_12 + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + (int)var6_12 + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                    }
                    ++var6_12;
                }
            }
        }
        if (createLoadBalancerRequest.getIpAddressType() != null) {
            request.addParameter("IpAddressType", StringUtils.fromString(createLoadBalancerRequest.getIpAddressType()));
        }
        return request;
    }
}

