/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest;
import com.amazonaws.services.ec2.model.DhcpConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateDhcpOptionsRequestMarshaller
implements Marshaller<Request<CreateDhcpOptionsRequest>, CreateDhcpOptionsRequest> {
    @Override
    public Request<CreateDhcpOptionsRequest> marshall(CreateDhcpOptionsRequest createDhcpOptionsRequest) {
        if (createDhcpOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDhcpOptionsRequest> request = new DefaultRequest<CreateDhcpOptionsRequest>(createDhcpOptionsRequest, "AmazonEC2");
        request.addParameter("Action", "CreateDhcpOptions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList createDhcpOptionsRequestDhcpConfigurationsList = (SdkInternalList)createDhcpOptionsRequest.getDhcpConfigurations();
        if (!createDhcpOptionsRequestDhcpConfigurationsList.isEmpty() || !createDhcpOptionsRequestDhcpConfigurationsList.isAutoConstruct()) {
            int dhcpConfigurationsListIndex = 1;
            for (DhcpConfiguration createDhcpOptionsRequestDhcpConfigurationsListValue : createDhcpOptionsRequestDhcpConfigurationsList) {
                SdkInternalList dhcpConfigurationValuesList;
                if (createDhcpOptionsRequestDhcpConfigurationsListValue.getKey() != null) {
                    request.addParameter("DhcpConfiguration." + dhcpConfigurationsListIndex + ".Key", StringUtils.fromString(createDhcpOptionsRequestDhcpConfigurationsListValue.getKey()));
                }
                if (!(dhcpConfigurationValuesList = (SdkInternalList)createDhcpOptionsRequestDhcpConfigurationsListValue.getValues()).isEmpty() || !dhcpConfigurationValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String dhcpConfigurationValuesListValue : dhcpConfigurationValuesList) {
                        if (dhcpConfigurationValuesListValue != null) {
                            request.addParameter("DhcpConfiguration." + dhcpConfigurationsListIndex + ".Value." + valuesListIndex, StringUtils.fromString(dhcpConfigurationValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++dhcpConfigurationsListIndex;
            }
        }
        return request;
    }
}

