/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.SlotStartTimeRangeRequest;
import com.amazonaws.services.ec2.model.transform.DescribeScheduledInstancesRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeScheduledInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeScheduledInstancesRequest> {
    private SdkInternalList<String> scheduledInstanceIds;
    private SlotStartTimeRangeRequest slotStartTimeRange;
    private String nextToken;
    private Integer maxResults;
    private SdkInternalList<Filter> filters;

    public List<String> getScheduledInstanceIds() {
        if (this.scheduledInstanceIds == null) {
            this.scheduledInstanceIds = new SdkInternalList();
        }
        return this.scheduledInstanceIds;
    }

    public void setScheduledInstanceIds(Collection<String> scheduledInstanceIds) {
        if (scheduledInstanceIds == null) {
            this.scheduledInstanceIds = null;
            return;
        }
        this.scheduledInstanceIds = new SdkInternalList<String>(scheduledInstanceIds);
    }

    public DescribeScheduledInstancesRequest withScheduledInstanceIds(String ... scheduledInstanceIds) {
        if (this.scheduledInstanceIds == null) {
            this.setScheduledInstanceIds(new SdkInternalList<String>(scheduledInstanceIds.length));
        }
        for (String ele : scheduledInstanceIds) {
            this.scheduledInstanceIds.add(ele);
        }
        return this;
    }

    public DescribeScheduledInstancesRequest withScheduledInstanceIds(Collection<String> scheduledInstanceIds) {
        this.setScheduledInstanceIds(scheduledInstanceIds);
        return this;
    }

    public void setSlotStartTimeRange(SlotStartTimeRangeRequest slotStartTimeRange) {
        this.slotStartTimeRange = slotStartTimeRange;
    }

    public SlotStartTimeRangeRequest getSlotStartTimeRange() {
        return this.slotStartTimeRange;
    }

    public DescribeScheduledInstancesRequest withSlotStartTimeRange(SlotStartTimeRangeRequest slotStartTimeRange) {
        this.setSlotStartTimeRange(slotStartTimeRange);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeScheduledInstancesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DescribeScheduledInstancesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList<Filter>(filters);
    }

    public DescribeScheduledInstancesRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters(new SdkInternalList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public DescribeScheduledInstancesRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    @Override
    public Request<DescribeScheduledInstancesRequest> getDryRunRequest() {
        Request<DescribeScheduledInstancesRequest> request = new DescribeScheduledInstancesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getScheduledInstanceIds() != null) {
            sb.append("ScheduledInstanceIds: ").append(this.getScheduledInstanceIds()).append(",");
        }
        if (this.getSlotStartTimeRange() != null) {
            sb.append("SlotStartTimeRange: ").append(this.getSlotStartTimeRange()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstancesRequest)) {
            return false;
        }
        DescribeScheduledInstancesRequest other = (DescribeScheduledInstancesRequest)obj;
        if (other.getScheduledInstanceIds() == null ^ this.getScheduledInstanceIds() == null) {
            return false;
        }
        if (other.getScheduledInstanceIds() != null && !other.getScheduledInstanceIds().equals(this.getScheduledInstanceIds())) {
            return false;
        }
        if (other.getSlotStartTimeRange() == null ^ this.getSlotStartTimeRange() == null) {
            return false;
        }
        if (other.getSlotStartTimeRange() != null && !other.getSlotStartTimeRange().equals(this.getSlotStartTimeRange())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getScheduledInstanceIds() == null ? 0 : this.getScheduledInstanceIds().hashCode());
        hashCode = 31 * hashCode + (this.getSlotStartTimeRange() == null ? 0 : this.getSlotStartTimeRange().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    @Override
    public DescribeScheduledInstancesRequest clone() {
        return (DescribeScheduledInstancesRequest)super.clone();
    }
}

