/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Reservation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeInstancesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Reservation> reservations;
    private String nextToken;

    public List<Reservation> getReservations() {
        if (this.reservations == null) {
            this.reservations = new SdkInternalList();
        }
        return this.reservations;
    }

    public void setReservations(Collection<Reservation> reservations) {
        if (reservations == null) {
            this.reservations = null;
            return;
        }
        this.reservations = new SdkInternalList<Reservation>(reservations);
    }

    public DescribeInstancesResult withReservations(Reservation ... reservations) {
        if (this.reservations == null) {
            this.setReservations(new SdkInternalList<Reservation>(reservations.length));
        }
        for (Reservation ele : reservations) {
            this.reservations.add(ele);
        }
        return this;
    }

    public DescribeInstancesResult withReservations(Collection<Reservation> reservations) {
        this.setReservations(reservations);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeInstancesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReservations() != null) {
            sb.append("Reservations: ").append(this.getReservations()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesResult)) {
            return false;
        }
        DescribeInstancesResult other = (DescribeInstancesResult)obj;
        if (other.getReservations() == null ^ this.getReservations() == null) {
            return false;
        }
        if (other.getReservations() != null && !other.getReservations().equals(this.getReservations())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReservations() == null ? 0 : this.getReservations().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeInstancesResult clone() {
        try {
            return (DescribeInstancesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

