/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.cognitoidp.model.AttributeType;
import com.amazonaws.services.cognitoidp.model.MFAOptionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetUserResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String username;
    private List<AttributeType> userAttributes;
    private List<MFAOptionType> mFAOptions;

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public GetUserResult withUsername(String username) {
        this.setUsername(username);
        return this;
    }

    public List<AttributeType> getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(Collection<AttributeType> userAttributes) {
        if (userAttributes == null) {
            this.userAttributes = null;
            return;
        }
        this.userAttributes = new ArrayList<AttributeType>(userAttributes);
    }

    public GetUserResult withUserAttributes(AttributeType ... userAttributes) {
        if (this.userAttributes == null) {
            this.setUserAttributes(new ArrayList<AttributeType>(userAttributes.length));
        }
        for (AttributeType ele : userAttributes) {
            this.userAttributes.add(ele);
        }
        return this;
    }

    public GetUserResult withUserAttributes(Collection<AttributeType> userAttributes) {
        this.setUserAttributes(userAttributes);
        return this;
    }

    public List<MFAOptionType> getMFAOptions() {
        return this.mFAOptions;
    }

    public void setMFAOptions(Collection<MFAOptionType> mFAOptions) {
        if (mFAOptions == null) {
            this.mFAOptions = null;
            return;
        }
        this.mFAOptions = new ArrayList<MFAOptionType>(mFAOptions);
    }

    public GetUserResult withMFAOptions(MFAOptionType ... mFAOptions) {
        if (this.mFAOptions == null) {
            this.setMFAOptions(new ArrayList<MFAOptionType>(mFAOptions.length));
        }
        for (MFAOptionType ele : mFAOptions) {
            this.mFAOptions.add(ele);
        }
        return this;
    }

    public GetUserResult withMFAOptions(Collection<MFAOptionType> mFAOptions) {
        this.setMFAOptions(mFAOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUsername() != null) {
            sb.append("Username: ").append(this.getUsername()).append(",");
        }
        if (this.getUserAttributes() != null) {
            sb.append("UserAttributes: ").append(this.getUserAttributes()).append(",");
        }
        if (this.getMFAOptions() != null) {
            sb.append("MFAOptions: ").append(this.getMFAOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserResult)) {
            return false;
        }
        GetUserResult other = (GetUserResult)obj;
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getUserAttributes() == null ^ this.getUserAttributes() == null) {
            return false;
        }
        if (other.getUserAttributes() != null && !other.getUserAttributes().equals(this.getUserAttributes())) {
            return false;
        }
        if (other.getMFAOptions() == null ^ this.getMFAOptions() == null) {
            return false;
        }
        return other.getMFAOptions() == null || other.getMFAOptions().equals(this.getMFAOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getUserAttributes() == null ? 0 : this.getUserAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getMFAOptions() == null ? 0 : this.getMFAOptions().hashCode());
        return hashCode;
    }

    public GetUserResult clone() {
        try {
            return (GetUserResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

