/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codecommit.model.UserInfo;
import com.amazonaws.services.codecommit.model.transform.CommitMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Commit
implements Serializable,
Cloneable,
StructuredPojo {
    private String treeId;
    private List<String> parents;
    private String message;
    private UserInfo author;
    private UserInfo committer;
    private String additionalData;

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public Commit withTreeId(String treeId) {
        this.setTreeId(treeId);
        return this;
    }

    public List<String> getParents() {
        return this.parents;
    }

    public void setParents(Collection<String> parents) {
        if (parents == null) {
            this.parents = null;
            return;
        }
        this.parents = new ArrayList<String>(parents);
    }

    public Commit withParents(String ... parents) {
        if (this.parents == null) {
            this.setParents(new ArrayList<String>(parents.length));
        }
        for (String ele : parents) {
            this.parents.add(ele);
        }
        return this;
    }

    public Commit withParents(Collection<String> parents) {
        this.setParents(parents);
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public Commit withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public void setAuthor(UserInfo author) {
        this.author = author;
    }

    public UserInfo getAuthor() {
        return this.author;
    }

    public Commit withAuthor(UserInfo author) {
        this.setAuthor(author);
        return this;
    }

    public void setCommitter(UserInfo committer) {
        this.committer = committer;
    }

    public UserInfo getCommitter() {
        return this.committer;
    }

    public Commit withCommitter(UserInfo committer) {
        this.setCommitter(committer);
        return this;
    }

    public void setAdditionalData(String additionalData) {
        this.additionalData = additionalData;
    }

    public String getAdditionalData() {
        return this.additionalData;
    }

    public Commit withAdditionalData(String additionalData) {
        this.setAdditionalData(additionalData);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTreeId() != null) {
            sb.append("TreeId: ").append(this.getTreeId()).append(",");
        }
        if (this.getParents() != null) {
            sb.append("Parents: ").append(this.getParents()).append(",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: ").append(this.getMessage()).append(",");
        }
        if (this.getAuthor() != null) {
            sb.append("Author: ").append(this.getAuthor()).append(",");
        }
        if (this.getCommitter() != null) {
            sb.append("Committer: ").append(this.getCommitter()).append(",");
        }
        if (this.getAdditionalData() != null) {
            sb.append("AdditionalData: ").append(this.getAdditionalData());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Commit)) {
            return false;
        }
        Commit other = (Commit)obj;
        if (other.getTreeId() == null ^ this.getTreeId() == null) {
            return false;
        }
        if (other.getTreeId() != null && !other.getTreeId().equals(this.getTreeId())) {
            return false;
        }
        if (other.getParents() == null ^ this.getParents() == null) {
            return false;
        }
        if (other.getParents() != null && !other.getParents().equals(this.getParents())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getAuthor() == null ^ this.getAuthor() == null) {
            return false;
        }
        if (other.getAuthor() != null && !other.getAuthor().equals(this.getAuthor())) {
            return false;
        }
        if (other.getCommitter() == null ^ this.getCommitter() == null) {
            return false;
        }
        if (other.getCommitter() != null && !other.getCommitter().equals(this.getCommitter())) {
            return false;
        }
        if (other.getAdditionalData() == null ^ this.getAdditionalData() == null) {
            return false;
        }
        return other.getAdditionalData() == null || other.getAdditionalData().equals(this.getAdditionalData());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTreeId() == null ? 0 : this.getTreeId().hashCode());
        hashCode = 31 * hashCode + (this.getParents() == null ? 0 : this.getParents().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getAuthor() == null ? 0 : this.getAuthor().hashCode());
        hashCode = 31 * hashCode + (this.getCommitter() == null ? 0 : this.getCommitter().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalData() == null ? 0 : this.getAdditionalData().hashCode());
        return hashCode;
    }

    public Commit clone() {
        try {
            return (Commit)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CommitMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

