/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevents.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cloudwatchevents.model.Target;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutTargetsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String rule;
    private List<Target> targets;

    public void setRule(String rule) {
        this.rule = rule;
    }

    public String getRule() {
        return this.rule;
    }

    public PutTargetsRequest withRule(String rule) {
        this.setRule(rule);
        return this;
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    public void setTargets(Collection<Target> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new ArrayList<Target>(targets);
    }

    public PutTargetsRequest withTargets(Target ... targets) {
        if (this.targets == null) {
            this.setTargets(new ArrayList<Target>(targets.length));
        }
        for (Target ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public PutTargetsRequest withTargets(Collection<Target> targets) {
        this.setTargets(targets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRule() != null) {
            sb.append("Rule: ").append(this.getRule()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTargetsRequest)) {
            return false;
        }
        PutTargetsRequest other = (PutTargetsRequest)obj;
        if (other.getRule() == null ^ this.getRule() == null) {
            return false;
        }
        if (other.getRule() != null && !other.getRule().equals(this.getRule())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        return other.getTargets() == null || other.getTargets().equals(this.getTargets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRule() == null ? 0 : this.getRule().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        return hashCode;
    }

    @Override
    public PutTargetsRequest clone() {
        return (PutTargetsRequest)super.clone();
    }
}

