/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.services.cloudsearchv2.model.ScalingParameters;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ScalingParametersStaxUnmarshaller
implements Unmarshaller<ScalingParameters, StaxUnmarshallerContext> {
    private static ScalingParametersStaxUnmarshaller instance;

    @Override
    public ScalingParameters unmarshall(StaxUnmarshallerContext context) throws Exception {
        ScalingParameters scalingParameters = new ScalingParameters();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return scalingParameters;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DesiredInstanceType", targetDepth)) {
                    scalingParameters.setDesiredInstanceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DesiredReplicationCount", targetDepth)) {
                    scalingParameters.setDesiredReplicationCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DesiredPartitionCount", targetDepth)) continue;
                scalingParameters.setDesiredPartitionCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return scalingParameters;
    }

    public static ScalingParametersStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ScalingParametersStaxUnmarshaller();
        }
        return instance;
    }
}

