/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.S3Origin;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class S3OriginStaxUnmarshaller
implements Unmarshaller<S3Origin, StaxUnmarshallerContext> {
    private static S3OriginStaxUnmarshaller instance;

    @Override
    public S3Origin unmarshall(StaxUnmarshallerContext context) throws Exception {
        S3Origin s3Origin = new S3Origin();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return s3Origin;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DomainName", targetDepth)) {
                    s3Origin.setDomainName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OriginAccessIdentity", targetDepth)) continue;
                s3Origin.setOriginAccessIdentity(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return s3Origin;
    }

    public static S3OriginStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3OriginStaxUnmarshaller();
        }
        return instance;
    }
}

