/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.CacheBehavior;
import com.amazonaws.services.cloudfront.model.CacheBehaviors;
import com.amazonaws.services.cloudfront.model.transform.CacheBehaviorStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class CacheBehaviorsStaxUnmarshaller
implements Unmarshaller<CacheBehaviors, StaxUnmarshallerContext> {
    private static CacheBehaviorsStaxUnmarshaller instance;

    @Override
    public CacheBehaviors unmarshall(StaxUnmarshallerContext context) throws Exception {
        CacheBehaviors cacheBehaviors = new CacheBehaviors();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return cacheBehaviors;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    cacheBehaviors.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    cacheBehaviors.withItems(new ArrayList<CacheBehavior>());
                    continue;
                }
                if (!context.testExpression("Items/CacheBehavior", targetDepth)) continue;
                cacheBehaviors.withItems(CacheBehaviorStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return cacheBehaviors;
    }

    public static CacheBehaviorsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CacheBehaviorsStaxUnmarshaller();
        }
        return instance;
    }
}

