/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.batch.model.ContainerOverrides;
import java.util.List;

@SdkInternalApi
public class ContainerOverridesMarshaller {
    private static final MarshallingInfo<Integer> VCPUS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vcpus").build();
    private static final MarshallingInfo<Integer> MEMORY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memory").build();
    private static final MarshallingInfo<List> COMMAND_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("command").build();
    private static final MarshallingInfo<List> ENVIRONMENT_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environment").build();
    private static final ContainerOverridesMarshaller instance = new ContainerOverridesMarshaller();

    public static ContainerOverridesMarshaller getInstance() {
        return instance;
    }

    public void marshall(ContainerOverrides containerOverrides, ProtocolMarshaller protocolMarshaller) {
        if (containerOverrides == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(containerOverrides.getVcpus(), VCPUS_BINDING);
            protocolMarshaller.marshall(containerOverrides.getMemory(), MEMORY_BINDING);
            protocolMarshaller.marshall(containerOverrides.getCommand(), COMMAND_BINDING);
            protocolMarshaller.marshall(containerOverrides.getEnvironment(), ENVIRONMENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

