/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.apigateway.model.ThrottleSettings;

@SdkInternalApi
public class ThrottleSettingsMarshaller {
    private static final MarshallingInfo<Integer> BURSTLIMIT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("burstLimit").build();
    private static final MarshallingInfo<Double> RATELIMIT_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rateLimit").build();
    private static final ThrottleSettingsMarshaller instance = new ThrottleSettingsMarshaller();

    public static ThrottleSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ThrottleSettings throttleSettings, ProtocolMarshaller protocolMarshaller) {
        if (throttleSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(throttleSettings.getBurstLimit(), BURSTLIMIT_BINDING);
            protocolMarshaller.marshall(throttleSettings.getRateLimit(), RATELIMIT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

