/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AllocationState;
import com.amazonaws.services.ec2.model.AutoPlacement;
import com.amazonaws.services.ec2.model.AvailableCapacity;
import com.amazonaws.services.ec2.model.HostInstance;
import com.amazonaws.services.ec2.model.HostProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Host
implements Serializable,
Cloneable {
    private String hostId;
    private String autoPlacement;
    private String hostReservationId;
    private String clientToken;
    private HostProperties hostProperties;
    private String state;
    private String availabilityZone;
    private SdkInternalList<HostInstance> instances;
    private AvailableCapacity availableCapacity;

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public String getHostId() {
        return this.hostId;
    }

    public Host withHostId(String hostId) {
        this.setHostId(hostId);
        return this;
    }

    public void setAutoPlacement(String autoPlacement) {
        this.autoPlacement = autoPlacement;
    }

    public String getAutoPlacement() {
        return this.autoPlacement;
    }

    public Host withAutoPlacement(String autoPlacement) {
        this.setAutoPlacement(autoPlacement);
        return this;
    }

    public void setAutoPlacement(AutoPlacement autoPlacement) {
        this.autoPlacement = autoPlacement.toString();
    }

    public Host withAutoPlacement(AutoPlacement autoPlacement) {
        this.setAutoPlacement(autoPlacement);
        return this;
    }

    public void setHostReservationId(String hostReservationId) {
        this.hostReservationId = hostReservationId;
    }

    public String getHostReservationId() {
        return this.hostReservationId;
    }

    public Host withHostReservationId(String hostReservationId) {
        this.setHostReservationId(hostReservationId);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public Host withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setHostProperties(HostProperties hostProperties) {
        this.hostProperties = hostProperties;
    }

    public HostProperties getHostProperties() {
        return this.hostProperties;
    }

    public Host withHostProperties(HostProperties hostProperties) {
        this.setHostProperties(hostProperties);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Host withState(String state) {
        this.setState(state);
        return this;
    }

    public void setState(AllocationState state) {
        this.state = state.toString();
    }

    public Host withState(AllocationState state) {
        this.setState(state);
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Host withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public List<HostInstance> getInstances() {
        if (this.instances == null) {
            this.instances = new SdkInternalList();
        }
        return this.instances;
    }

    public void setInstances(Collection<HostInstance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        this.instances = new SdkInternalList<HostInstance>(instances);
    }

    public Host withInstances(HostInstance ... instances) {
        if (this.instances == null) {
            this.setInstances(new SdkInternalList<HostInstance>(instances.length));
        }
        for (HostInstance ele : instances) {
            this.instances.add(ele);
        }
        return this;
    }

    public Host withInstances(Collection<HostInstance> instances) {
        this.setInstances(instances);
        return this;
    }

    public void setAvailableCapacity(AvailableCapacity availableCapacity) {
        this.availableCapacity = availableCapacity;
    }

    public AvailableCapacity getAvailableCapacity() {
        return this.availableCapacity;
    }

    public Host withAvailableCapacity(AvailableCapacity availableCapacity) {
        this.setAvailableCapacity(availableCapacity);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHostId() != null) {
            sb.append("HostId: ").append(this.getHostId()).append(",");
        }
        if (this.getAutoPlacement() != null) {
            sb.append("AutoPlacement: ").append(this.getAutoPlacement()).append(",");
        }
        if (this.getHostReservationId() != null) {
            sb.append("HostReservationId: ").append(this.getHostReservationId()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getHostProperties() != null) {
            sb.append("HostProperties: ").append(this.getHostProperties()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone()).append(",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: ").append(this.getInstances()).append(",");
        }
        if (this.getAvailableCapacity() != null) {
            sb.append("AvailableCapacity: ").append(this.getAvailableCapacity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host)obj;
        if (other.getHostId() == null ^ this.getHostId() == null) {
            return false;
        }
        if (other.getHostId() != null && !other.getHostId().equals(this.getHostId())) {
            return false;
        }
        if (other.getAutoPlacement() == null ^ this.getAutoPlacement() == null) {
            return false;
        }
        if (other.getAutoPlacement() != null && !other.getAutoPlacement().equals(this.getAutoPlacement())) {
            return false;
        }
        if (other.getHostReservationId() == null ^ this.getHostReservationId() == null) {
            return false;
        }
        if (other.getHostReservationId() != null && !other.getHostReservationId().equals(this.getHostReservationId())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getHostProperties() == null ^ this.getHostProperties() == null) {
            return false;
        }
        if (other.getHostProperties() != null && !other.getHostProperties().equals(this.getHostProperties())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getAvailableCapacity() == null ^ this.getAvailableCapacity() == null) {
            return false;
        }
        return other.getAvailableCapacity() == null || other.getAvailableCapacity().equals(this.getAvailableCapacity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHostId() == null ? 0 : this.getHostId().hashCode());
        hashCode = 31 * hashCode + (this.getAutoPlacement() == null ? 0 : this.getAutoPlacement().hashCode());
        hashCode = 31 * hashCode + (this.getHostReservationId() == null ? 0 : this.getHostReservationId().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getHostProperties() == null ? 0 : this.getHostProperties().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getAvailableCapacity() == null ? 0 : this.getAvailableCapacity().hashCode());
        return hashCode;
    }

    public Host clone() {
        try {
            return (Host)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

