/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gamelift.model.GameProperty;
import com.amazonaws.services.gamelift.model.GameSessionPlacementState;
import com.amazonaws.services.gamelift.model.PlayerLatency;
import com.amazonaws.services.gamelift.model.transform.GameSessionPlacementMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GameSessionPlacement
implements Serializable,
Cloneable,
StructuredPojo {
    private String placementId;
    private String gameSessionQueueName;
    private String status;
    private List<GameProperty> gameProperties;
    private Integer maximumPlayerSessionCount;
    private String gameSessionName;
    private String gameSessionArn;
    private String gameSessionRegion;
    private List<PlayerLatency> playerLatencies;
    private Date startTime;
    private Date endTime;

    public void setPlacementId(String placementId) {
        this.placementId = placementId;
    }

    public String getPlacementId() {
        return this.placementId;
    }

    public GameSessionPlacement withPlacementId(String placementId) {
        this.setPlacementId(placementId);
        return this;
    }

    public void setGameSessionQueueName(String gameSessionQueueName) {
        this.gameSessionQueueName = gameSessionQueueName;
    }

    public String getGameSessionQueueName() {
        return this.gameSessionQueueName;
    }

    public GameSessionPlacement withGameSessionQueueName(String gameSessionQueueName) {
        this.setGameSessionQueueName(gameSessionQueueName);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public GameSessionPlacement withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    @JsonIgnore
    public void setStatus(GameSessionPlacementState status) {
        this.status = status.toString();
    }

    public GameSessionPlacement withStatus(GameSessionPlacementState status) {
        this.setStatus(status);
        return this;
    }

    public List<GameProperty> getGameProperties() {
        return this.gameProperties;
    }

    public void setGameProperties(Collection<GameProperty> gameProperties) {
        if (gameProperties == null) {
            this.gameProperties = null;
            return;
        }
        this.gameProperties = new ArrayList<GameProperty>(gameProperties);
    }

    public GameSessionPlacement withGameProperties(GameProperty ... gameProperties) {
        if (this.gameProperties == null) {
            this.setGameProperties(new ArrayList<GameProperty>(gameProperties.length));
        }
        for (GameProperty ele : gameProperties) {
            this.gameProperties.add(ele);
        }
        return this;
    }

    public GameSessionPlacement withGameProperties(Collection<GameProperty> gameProperties) {
        this.setGameProperties(gameProperties);
        return this;
    }

    public void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
        this.maximumPlayerSessionCount = maximumPlayerSessionCount;
    }

    public Integer getMaximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public GameSessionPlacement withMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
        this.setMaximumPlayerSessionCount(maximumPlayerSessionCount);
        return this;
    }

    public void setGameSessionName(String gameSessionName) {
        this.gameSessionName = gameSessionName;
    }

    public String getGameSessionName() {
        return this.gameSessionName;
    }

    public GameSessionPlacement withGameSessionName(String gameSessionName) {
        this.setGameSessionName(gameSessionName);
        return this;
    }

    public void setGameSessionArn(String gameSessionArn) {
        this.gameSessionArn = gameSessionArn;
    }

    public String getGameSessionArn() {
        return this.gameSessionArn;
    }

    public GameSessionPlacement withGameSessionArn(String gameSessionArn) {
        this.setGameSessionArn(gameSessionArn);
        return this;
    }

    public void setGameSessionRegion(String gameSessionRegion) {
        this.gameSessionRegion = gameSessionRegion;
    }

    public String getGameSessionRegion() {
        return this.gameSessionRegion;
    }

    public GameSessionPlacement withGameSessionRegion(String gameSessionRegion) {
        this.setGameSessionRegion(gameSessionRegion);
        return this;
    }

    public List<PlayerLatency> getPlayerLatencies() {
        return this.playerLatencies;
    }

    public void setPlayerLatencies(Collection<PlayerLatency> playerLatencies) {
        if (playerLatencies == null) {
            this.playerLatencies = null;
            return;
        }
        this.playerLatencies = new ArrayList<PlayerLatency>(playerLatencies);
    }

    public GameSessionPlacement withPlayerLatencies(PlayerLatency ... playerLatencies) {
        if (this.playerLatencies == null) {
            this.setPlayerLatencies(new ArrayList<PlayerLatency>(playerLatencies.length));
        }
        for (PlayerLatency ele : playerLatencies) {
            this.playerLatencies.add(ele);
        }
        return this;
    }

    public GameSessionPlacement withPlayerLatencies(Collection<PlayerLatency> playerLatencies) {
        this.setPlayerLatencies(playerLatencies);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public GameSessionPlacement withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public GameSessionPlacement withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPlacementId() != null) {
            sb.append("PlacementId: ").append(this.getPlacementId()).append(",");
        }
        if (this.getGameSessionQueueName() != null) {
            sb.append("GameSessionQueueName: ").append(this.getGameSessionQueueName()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getGameProperties() != null) {
            sb.append("GameProperties: ").append(this.getGameProperties()).append(",");
        }
        if (this.getMaximumPlayerSessionCount() != null) {
            sb.append("MaximumPlayerSessionCount: ").append(this.getMaximumPlayerSessionCount()).append(",");
        }
        if (this.getGameSessionName() != null) {
            sb.append("GameSessionName: ").append(this.getGameSessionName()).append(",");
        }
        if (this.getGameSessionArn() != null) {
            sb.append("GameSessionArn: ").append(this.getGameSessionArn()).append(",");
        }
        if (this.getGameSessionRegion() != null) {
            sb.append("GameSessionRegion: ").append(this.getGameSessionRegion()).append(",");
        }
        if (this.getPlayerLatencies() != null) {
            sb.append("PlayerLatencies: ").append(this.getPlayerLatencies()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSessionPlacement)) {
            return false;
        }
        GameSessionPlacement other = (GameSessionPlacement)obj;
        if (other.getPlacementId() == null ^ this.getPlacementId() == null) {
            return false;
        }
        if (other.getPlacementId() != null && !other.getPlacementId().equals(this.getPlacementId())) {
            return false;
        }
        if (other.getGameSessionQueueName() == null ^ this.getGameSessionQueueName() == null) {
            return false;
        }
        if (other.getGameSessionQueueName() != null && !other.getGameSessionQueueName().equals(this.getGameSessionQueueName())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getGameProperties() == null ^ this.getGameProperties() == null) {
            return false;
        }
        if (other.getGameProperties() != null && !other.getGameProperties().equals(this.getGameProperties())) {
            return false;
        }
        if (other.getMaximumPlayerSessionCount() == null ^ this.getMaximumPlayerSessionCount() == null) {
            return false;
        }
        if (other.getMaximumPlayerSessionCount() != null && !other.getMaximumPlayerSessionCount().equals(this.getMaximumPlayerSessionCount())) {
            return false;
        }
        if (other.getGameSessionName() == null ^ this.getGameSessionName() == null) {
            return false;
        }
        if (other.getGameSessionName() != null && !other.getGameSessionName().equals(this.getGameSessionName())) {
            return false;
        }
        if (other.getGameSessionArn() == null ^ this.getGameSessionArn() == null) {
            return false;
        }
        if (other.getGameSessionArn() != null && !other.getGameSessionArn().equals(this.getGameSessionArn())) {
            return false;
        }
        if (other.getGameSessionRegion() == null ^ this.getGameSessionRegion() == null) {
            return false;
        }
        if (other.getGameSessionRegion() != null && !other.getGameSessionRegion().equals(this.getGameSessionRegion())) {
            return false;
        }
        if (other.getPlayerLatencies() == null ^ this.getPlayerLatencies() == null) {
            return false;
        }
        if (other.getPlayerLatencies() != null && !other.getPlayerLatencies().equals(this.getPlayerLatencies())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        return other.getEndTime() == null || other.getEndTime().equals(this.getEndTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPlacementId() == null ? 0 : this.getPlacementId().hashCode());
        hashCode = 31 * hashCode + (this.getGameSessionQueueName() == null ? 0 : this.getGameSessionQueueName().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getGameProperties() == null ? 0 : this.getGameProperties().hashCode());
        hashCode = 31 * hashCode + (this.getMaximumPlayerSessionCount() == null ? 0 : this.getMaximumPlayerSessionCount().hashCode());
        hashCode = 31 * hashCode + (this.getGameSessionName() == null ? 0 : this.getGameSessionName().hashCode());
        hashCode = 31 * hashCode + (this.getGameSessionArn() == null ? 0 : this.getGameSessionArn().hashCode());
        hashCode = 31 * hashCode + (this.getGameSessionRegion() == null ? 0 : this.getGameSessionRegion().hashCode());
        hashCode = 31 * hashCode + (this.getPlayerLatencies() == null ? 0 : this.getPlayerLatencies().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        return hashCode;
    }

    public GameSessionPlacement clone() {
        try {
            return (GameSessionPlacement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GameSessionPlacementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

